/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegesListener
extends DefaultEventListener
implements ExternalEventListener {
    private static Logger logger = LoggerFactory.getLogger(PrivilegesListener.class);

    @Override
    public int getEventTypes() {
        return 3;
    }

    @Override
    public String getPath() {
        return "/permissions";
    }

    public void onEvent(EventIterator events) {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JahiaPrivilegeRegistry.init(session);
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Cannot refresh permissions", (Throwable)e);
        }
    }
}

