/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import javax.servlet.http.HttpSession;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.gwt20.managed.AtmosphereMessageInterceptor;
import org.atmosphere.gwt20.server.GwtRpcInterceptor;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

@ManagedService(path="/atmosphere/rpc", interceptors={AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, GwtRpcInterceptor.class, SuspendTrackerInterceptor.class, AtmosphereMessageInterceptor.class, BroadcastOnPostAtmosphereInterceptor.class, IdleResourceInterceptor.class})
public class ManagedGWTResource {
    static final Logger logger = LoggerFactory.getLogger(ManagedGWTResource.class);
    public static final String GWT_BROADCASTER_ID = "org.jahia.broadcaster";

    @Ready
    public String onReady(AtmosphereResource r) {
        r.suspend();
        BroadcasterFactory broadcasterFactory = r.getAtmosphereConfig().getBroadcasterFactory();
        broadcasterFactory.lookup((Object)GWT_BROADCASTER_ID, true).addAtmosphereResource(r);
        JahiaUser user = (JahiaUser)r.getRequest().getSession(true).getAttribute("org.jahia.usermanager.jahiauser");
        if (user != null) {
            broadcasterFactory.lookup((Object)(GWT_BROADCASTER_ID + user.getName()), true).addAtmosphereResource(r);
        }
        SpringContextSingleton.getInstance().publishEvent(new AtmosphereClientReadyEvent(r));
        logger.debug("Received RPC GET");
        return "";
    }

    @Disconnect
    public void disconnected(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            HttpSession session = event.getResource().getRequest().getSession();
            JahiaUser user = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
            String userName = user != null ? user.getUsername() : null;
            logger.info("User's AtmosphereResource unexpectedly disconnected! user=[{}] session=[{}]", (Object)userName, (Object)session.getId());
        } else if (event.isClosedByClient() && logger.isDebugEnabled()) {
            HttpSession session = event.getResource().getRequest().getSession();
            JahiaUser user = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
            logger.debug("User closed the connection for AtmosphereResource! user=[{}] session=[{}]", (Object)(user != null ? user.getUsername() : null), (Object)session.getId());
        }
        SpringContextSingleton.getInstance().publishEvent(new AtmosphereClientDisconnectedEvent(event.getResource()));
    }

    @Post
    public void post(AtmosphereResource r) {
        if (logger.isDebugEnabled()) {
            logger.info("POST received with transport {}", (Object)r.transport());
        }
    }

    public class AtmosphereClientDisconnectedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;

        public AtmosphereClientDisconnectedEvent(AtmosphereResource resource) {
            super((Object)resource);
        }

        public AtmosphereResource getResource() {
            return (AtmosphereResource)super.getSource();
        }
    }

    public class AtmosphereClientReadyEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;

        public AtmosphereClientReadyEvent(AtmosphereResource resource) {
            super((Object)resource);
        }

        public AtmosphereResource getResource() {
            return (AtmosphereResource)super.getSource();
        }
    }
}

