/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.SourceFormatter;
import org.jahia.bin.Jahia;
import org.jahia.utils.xml.JahiaTransformerFactory;
import org.outerj.daisy.diff.HtmlCleaner;
import org.outerj.daisy.diff.XslFilter;
import org.outerj.daisy.diff.html.HTMLDiffer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.html.dom.DomTreeBuilder;
import org.outerj.daisy.diff.output.DiffOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DiffHelper {
    private static final transient Logger logger = LoggerFactory.getLogger(DiffHelper.class);
    private static final Pattern LIVE_WS_PATTERN = Pattern.compile("/live/");

    public String getHighlighted(String original, String amendment) {
        StringWriter sw = new StringWriter();
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)JahiaTransformerFactory.newInstance();
            TransformerHandler result = transformerFactory.newTransformerHandler();
            result.setResult(new StreamResult(sw));
            XslFilter filter = new XslFilter();
            if (original.contains("/files/default/") || amendment.contains("/files/default/")) {
                original = LIVE_WS_PATTERN.matcher(original).replaceAll("/default/");
                amendment = LIVE_WS_PATTERN.matcher(amendment).replaceAll("/default/");
            }
            original = new SourceFormatter((Segment)new Source((CharSequence)original)).toString();
            amendment = new SourceFormatter((Segment)new Source((CharSequence)amendment)).toString();
            ContentHandler postProcess = filter.xsl((ContentHandler)result, "jahiahtmlheader.xsl");
            Locale locale = Locale.ENGLISH;
            String prefix = "diff";
            HtmlCleaner cleaner = new HtmlCleaner();
            InputSource oldSource = new InputSource(new StringReader(original));
            InputSource newSource = new InputSource(new StringReader(amendment));
            DomTreeBuilder oldHandler = new DomTreeBuilder();
            cleaner.cleanAndParse(oldSource, (ContentHandler)oldHandler);
            TextNodeComparator leftComparator = new TextNodeComparator((DomTree)oldHandler, locale);
            DomTreeBuilder newHandler = new DomTreeBuilder();
            cleaner.cleanAndParse(newSource, (ContentHandler)newHandler);
            TextNodeComparator rightComparator = new TextNodeComparator((DomTree)newHandler, locale);
            postProcess.startDocument();
            postProcess.startElement("", "diffreport", "diffreport", new AttributesImpl());
            this.addDiffCss(postProcess);
            postProcess.startElement("", "diff", "diff", new AttributesImpl());
            HtmlSaxDiffOutput output = new HtmlSaxDiffOutput(postProcess, "diff");
            HTMLDiffer differ = new HTMLDiffer((DiffOutput)output);
            differ.diff(rightComparator, leftComparator);
            postProcess.endElement("", "diff", "diff");
            postProcess.endElement("", "diffreport", "diffreport");
            postProcess.endDocument();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return sw.toString();
    }

    private void addDiffCss(ContentHandler handler) throws SAXException {
        handler.startElement("", "css", "css", new AttributesImpl());
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "href", "href", "CDATA", Jahia.getContextPath() + "/gwt/resources/css/diff.css");
        attr.addAttribute("", "type", "type", "CDATA", "text/css");
        attr.addAttribute("", "rel", "rel", "CDATA", "stylesheet");
        handler.startElement("", "link", "link", attr);
        handler.endElement("", "link", "link");
        handler.endElement("", "css", "css");
    }
}

