/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageHelper {
    private static Logger logger = LoggerFactory.getLogger(LanguageHelper.class);

    public List<GWTJahiaLanguage> getLanguages(@NotNull JCRSiteNode site, Locale currentLocale) {
        ArrayList<GWTJahiaLanguage> items = new ArrayList<GWTJahiaLanguage>();
        try {
            JCRSiteNode siteToCheck = site;
            if (site.isNodeType("jnt:module") || CollectionUtils.isEmpty(site.getLanguages())) {
                siteToCheck = (JCRSiteNode)ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey("systemsite");
            }
            Set<String> mandatoryLanguages = siteToCheck.getMandatoryLanguages();
            Set<String> activeLanguages = siteToCheck.getActiveLiveLanguages();
            TreeSet<String> orderedLanguages = new TreeSet<String>(siteToCheck.getLanguages());
            for (String langCode : orderedLanguages) {
                GWTJahiaLanguage item = new GWTJahiaLanguage();
                item.setLanguage(langCode);
                item.setDisplayName(LanguageHelper.getDisplayName(langCode));
                item.setImage(LanguageHelper.getLangIcon(Jahia.getContextPath(), LanguageCodeConverters.languageCodeToLocale(langCode)));
                item.setCurrent(Boolean.valueOf(currentLocale != null && langCode.equalsIgnoreCase(currentLocale.toString())));
                item.setActive(Boolean.valueOf(activeLanguages.contains(langCode)));
                item.setMandatory(Boolean.valueOf(mandatoryLanguages.contains(langCode)));
                items.add(item);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving languages for site/module: " + site.getPath(), (Throwable)e);
        }
        return items;
    }

    public GWTJahiaLanguage getCurrentLang(Locale locale) {
        String langCode = locale.toString();
        GWTJahiaLanguage item = new GWTJahiaLanguage();
        item.setLanguage(langCode);
        item.setDisplayName(LanguageHelper.getDisplayName(langCode));
        item.setImage(LanguageHelper.getLangIcon(Jahia.getContextPath(), locale));
        return item;
    }

    public static String getLangIcon(String contextPath, Locale locale) {
        if ("".equals(locale.getCountry())) {
            return contextPath + "/css/images/flags/" + locale.getLanguage().toLowerCase() + "_on.png";
        }
        return contextPath + "/css/images/flags/plain/flag_" + Patterns.SPACE.matcher(locale.getDisplayCountry(Locale.ENGLISH).toLowerCase()).replaceAll("_") + ".png";
    }

    public static String getDisplayName(String langCode) {
        if (langCode == null) {
            return "";
        }
        langCode = Patterns.DASH.matcher(langCode).replaceAll("_");
        Locale currentLocale = LanguageCodeConverters.getLocaleFromCode(langCode);
        return StringUtils.capitalize((String)currentLocale.getDisplayName(currentLocale));
    }
}

