/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.widget.poller.ContentUnpublishedEvent;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.helper.WorkflowHelper;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.atmosphere.AtmosphereServlet;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationHelper {
    private static final Logger logger = LoggerFactory.getLogger(PublicationHelper.class);
    private JCRPublicationService publicationService;
    private ComplexPublicationService complexPublicationService;
    private WorkflowHelper workflowHelper;
    private WorkflowService workflowService;

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void setComplexPublicationService(ComplexPublicationService complexPublicationService) {
        this.complexPublicationService = complexPublicationService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowHelper getWorkflowHelper() {
        return this.workflowHelper;
    }

    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    public Map<String, GWTJahiaPublicationInfo> getAggregatedPublicationInfosByLanguage(JCRNodeWrapper node, Set<String> languages, JCRSessionWrapper currentUserSession, boolean includeReferences, boolean includeSubNodes) throws GWTJahiaServiceException {
        try {
            HashMap<String, GWTJahiaPublicationInfo> infos = new HashMap<String, GWTJahiaPublicationInfo>(languages.size());
            for (String language : languages) {
                ComplexPublicationService.AggregatedPublicationInfo aggregatedInfo = this.complexPublicationService.getAggregatedPublicationInfo(node.getIdentifier(), language, includeSubNodes, includeReferences, currentUserSession);
                GWTJahiaPublicationInfo gwtInfo = new GWTJahiaPublicationInfo(node.getIdentifier(), aggregatedInfo.getPublicationStatus());
                gwtInfo.setLocked(Boolean.valueOf(aggregatedInfo.isLocked()));
                gwtInfo.setWorkInProgress(Boolean.valueOf(aggregatedInfo.isWorkInProgress()));
                gwtInfo.setIsAllowedToPublishWithoutWorkflow(Boolean.valueOf(aggregatedInfo.isAllowedToPublishWithoutWorkflow()));
                gwtInfo.setIsNonRootMarkedForDeletion(Boolean.valueOf(aggregatedInfo.isNonRootMarkedForDeletion()));
                infos.put(language, gwtInfo);
            }
            return infos;
        }
        catch (Exception e) {
            logger.error("Cannot get publication status for node " + node.getPath() + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publication status for node " + node.getPath() + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Map<String, List<GWTJahiaPublicationInfo>> getFullPublicationInfosByLanguage(List<String> uuids, Set<String> languages, JCRSessionWrapper currentUserSession, boolean allSubTree) throws GWTJahiaServiceException {
        List<GWTJahiaPublicationInfo> all = this.getFullPublicationInfos(uuids, languages, currentUserSession, allSubTree, false, false);
        HashMap<String, List<GWTJahiaPublicationInfo>> res = new HashMap<String, List<GWTJahiaPublicationInfo>>();
        for (GWTJahiaPublicationInfo info : all) {
            if (!res.containsKey(info.getLanguage())) {
                res.put(info.getLanguage(), new ArrayList());
            }
            ((List)res.get(info.getLanguage())).add(info);
        }
        return res;
    }

    public List<GWTJahiaPublicationInfo> getFullPublicationInfos(List<String> uuids, Set<String> languages, JCRSessionWrapper currentUserSession, boolean allSubTree, boolean checkForUnpublication) throws GWTJahiaServiceException {
        return this.getFullPublicationInfos(uuids, languages, currentUserSession, allSubTree, false, checkForUnpublication);
    }

    public List<GWTJahiaPublicationInfo> getFullPublicationInfos(List<String> uuids, Set<String> languages, JCRSessionWrapper currentUserSession, boolean allSubTree, boolean includeRemoved, boolean checkForUnpublication) throws GWTJahiaServiceException {
        try {
            Collection<ComplexPublicationService.FullPublicationInfo> infos = checkForUnpublication ? this.complexPublicationService.getFullUnpublicationInfos(uuids, languages, allSubTree, currentUserSession) : this.complexPublicationService.getFullPublicationInfos(uuids, languages, allSubTree, includeRemoved, currentUserSession);
            return PublicationHelper.convert(infos, currentUserSession);
        }
        catch (Exception e) {
            logger.error("Cannot get nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static List<GWTJahiaPublicationInfo> convert(Collection<ComplexPublicationService.FullPublicationInfo> infos, JCRSessionWrapper session) {
        LinkedList<GWTJahiaPublicationInfo> gwtInfos = new LinkedList<GWTJahiaPublicationInfo>();
        for (ComplexPublicationService.FullPublicationInfo info : infos) {
            GWTJahiaPublicationInfo gwtInfo = PublicationHelper.convert(info, session);
            gwtInfos.add(gwtInfo);
        }
        return gwtInfos;
    }

    private static GWTJahiaPublicationInfo convert(ComplexPublicationService.FullPublicationInfo info, JCRSessionWrapper session) {
        GWTJahiaPublicationInfo gwtInfo = new GWTJahiaPublicationInfo(info.getNodeIdentifier(), info.getPublicationStatus());
        gwtInfo.setPath(info.getNodePath());
        gwtInfo.setTitle(info.getNodeTitle());
        gwtInfo.setNodetype(info.getNodeType() != null ? info.getNodeType().getLabel(session.getLocale()) : "");
        if (info.getNodeType().isNodeType("jnt:page")) {
            gwtInfo.set("isPage", (Object)Boolean.TRUE);
        }
        gwtInfo.setMainUUID(info.getPublicationRootNodeIdentifier());
        gwtInfo.setMainPath(info.getPublicationRootNodePath());
        gwtInfo.setMainPathIndex(Integer.valueOf(info.getPublicationRootNodePathIndex()));
        gwtInfo.setLocked(Boolean.valueOf(info.isLocked()));
        gwtInfo.setWorkInProgress(Boolean.valueOf(info.isWorkInProgress()));
        gwtInfo.setWorkflowTitle(info.getWorkflowTitle());
        gwtInfo.setWorkflowDefinition(info.getWorkflowDefinition());
        gwtInfo.setWorkflowGroup(info.getWorkflowGroup());
        gwtInfo.setIsAllowedToPublishWithoutWorkflow(Boolean.valueOf(info.isAllowedToPublishWithoutWorkflow()));
        gwtInfo.setLanguage(info.getLanguage());
        gwtInfo.setI18NUuid(info.getTranslationNodeIdentifier());
        Collection<String> deletedTranslationNodeIdentifiers = info.getDeletedTranslationNodeIdentifiers();
        if (!deletedTranslationNodeIdentifiers.isEmpty()) {
            gwtInfo.setDeletedI18nUuid(StringUtils.join(deletedTranslationNodeIdentifiers, (char)' '));
        }
        gwtInfo.setIsNonRootMarkedForDeletion(Boolean.valueOf(info.isNonRootMarkedForDeletion()));
        return gwtInfo;
    }

    public Map<PublicationWorkflow, WorkflowDefinition> createPublicationWorkflows(List<GWTJahiaPublicationInfo> all) {
        TreeMap infosListByWorflowGroup = new TreeMap();
        HashMap<String, String> workflowGroupToKey = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : all) {
            String workflowGroup = info.getWorkflowGroup();
            if (!infosListByWorflowGroup.containsKey(workflowGroup)) {
                infosListByWorflowGroup.put(workflowGroup, new ArrayList());
            }
            ((List)infosListByWorflowGroup.get(workflowGroup)).add(info);
            if (info.getWorkflowDefinition() == null) continue;
            workflowGroupToKey.put(info.getWorkflowGroup(), info.getWorkflowDefinition());
            if (keys.contains(info.getWorkflowDefinition())) continue;
            keys.add(info.getWorkflowDefinition());
        }
        LinkedHashMap<PublicationWorkflow, WorkflowDefinition> result = new LinkedHashMap<PublicationWorkflow, WorkflowDefinition>();
        HashMap<String, WorkflowDefinition> workflows = new HashMap<String, WorkflowDefinition>();
        for (String string : keys) {
            WorkflowDefinition w = this.workflowService.getWorkflowDefinition(StringUtils.substringBefore((String)string, (String)":"), StringUtils.substringAfter((String)string, (String)":"), null);
            workflows.put(string, w);
        }
        for (Map.Entry entry : infosListByWorflowGroup.entrySet()) {
            result.put(new PublicationWorkflow((List)entry.getValue()), (WorkflowDefinition)workflows.get(workflowGroupToKey.get(entry.getKey())));
        }
        return result;
    }

    public void publish(List<String> uuids, JCRSessionWrapper session, JCRSiteNode site, List<GWTJahiaNodeProperty> properties, List<String> comments) throws GWTJahiaServiceException {
        try {
            String workspaceName = session.getWorkspace().getName();
            ArrayList<String> publicationPath = new ArrayList<String>();
            for (String uuid : uuids) {
                try {
                    publicationPath.add(session.getNodeByIdentifier(uuid).getPath());
                }
                catch (RepositoryException e) {
                    logger.debug("Cannot get item " + uuid, (Throwable)e);
                }
            }
            JobDetail jobDetail = BackgroundJob.createJahiaJob("Publication", PublicationJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put("sitekey", site.getName());
            jobDataMap.put((Object)"publicationProperties", properties);
            jobDataMap.put((Object)"publicationComments", comments);
            jobDataMap.put((Object)"publicationInfos", uuids);
            jobDataMap.put((Object)"publicationPaths", publicationPath);
            jobDataMap.put("source", workspaceName);
            jobDataMap.put("destination", "live");
            jobDataMap.put("checkPermissions", true);
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void publish(List<String> uuids) throws GWTJahiaServiceException {
        try {
            this.publicationService.publish(uuids, "default", "live", null);
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void unpublish(List<String> uuids, Set<String> languages, JahiaUser user) throws GWTJahiaServiceException {
        try {
            this.sendPushNotiticationEvent(this.publicationService.unpublish(uuids));
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get unpublish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void sendPushNotiticationEvent(List<String> uuids) {
        Broadcaster broadcaster;
        BroadcasterFactory broadcasterFactory = AtmosphereServlet.getBroadcasterFactory();
        if (broadcasterFactory != null && (broadcaster = broadcasterFactory.lookup((Object)"org.jahia.broadcaster")) != null) {
            broadcaster.broadcast((Object)new ContentUnpublishedEvent(uuids));
        }
    }
}

