/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.seo.GWTJahiaUrlMapping;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;

public class SeoHelper {
    private VanityUrlService urlService;

    public List<GWTJahiaUrlMapping> getUrlMappings(GWTJahiaNode gwtNode, String locale, JCRSessionWrapper session) throws ItemNotFoundException, RepositoryException {
        ArrayList<GWTJahiaUrlMapping> mappings = new ArrayList<GWTJahiaUrlMapping>();
        List<VanityUrl> urls = this.urlService.getVanityUrls(session.getNodeByIdentifier(gwtNode.getUUID()), locale, session);
        for (VanityUrl vanityUrl : urls) {
            mappings.add(new GWTJahiaUrlMapping(vanityUrl.getPath(), vanityUrl.getUrl(), vanityUrl.getLanguage(), vanityUrl.isDefaultMapping(), vanityUrl.isActive()));
        }
        return mappings;
    }

    public void saveUrlMappings(GWTJahiaNode gwtNode, Map<String, List<GWTJahiaUrlMapping>> mappings, JCRSessionWrapper session) throws ItemNotFoundException, RepositoryException, ConstraintViolationException {
        String site = JCRContentUtils.getSiteKey(gwtNode.getPath());
        LinkedList<VanityUrl> vanityUrls = new LinkedList<VanityUrl>();
        for (List<GWTJahiaUrlMapping> mappingsPerLang : mappings.values()) {
            for (GWTJahiaUrlMapping mapping : mappingsPerLang) {
                if (!StringUtils.isNotBlank((String)mapping.getUrl())) continue;
                VanityUrl url = new VanityUrl(mapping.getUrl(), site, mapping.getLanguage(), mapping.isDefault(), mapping.isActive());
                url.setPath(mapping.getPath());
                if (gwtNode.isFile().booleanValue()) {
                    url.setFile(true);
                }
                vanityUrls.add(url);
            }
        }
        this.urlService.saveVanityUrlMappings(session.getNodeByIdentifier(gwtNode.getUUID()), vanityUrls, mappings.keySet());
    }

    public void setUrlService(VanityUrlService urlService) {
        this.urlService = urlService;
    }
}

