/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.bin.Render;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;

public class DefaultPutAction
extends Action {
    private MetricsLoggingService loggingService;

    public MetricsLoggingService getLoggingService() {
        return this.loggingService;
    }

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, JCRSessionWrapper session, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper node = session.getNode(urlResolver.getPath());
        String primaryNodeTypeName = node.getPrimaryNodeTypeName();
        session.checkout(node);
        if (parameters.containsKey("jcrRemoveMixin")) {
            for (String string : parameters.get("jcrRemoveMixin")) {
                node.removeMixin(string);
            }
        }
        if (parameters.containsKey("jcr:mixinTypes")) {
            for (String string : parameters.get("jcr:mixinTypes")) {
                node.addMixin(string);
            }
        }
        Set<Map.Entry<String, List<String>>> set = parameters.entrySet();
        try {
            for (Map.Entry<String, List<String>> entry : set) {
                String key = entry.getKey();
                if (Render.getReservedParameters().contains(key)) continue;
                List<String> values = entry.getValue();
                ExtendedPropertyDefinition propertyDefinition = node.getApplicablePropertyDefinition(key);
                if (propertyDefinition == null) continue;
                if (propertyDefinition.isMultiple()) {
                    if (values.size() == 1 && values.get(0).equals("jcrClearAllValues")) {
                        node.setProperty(key, new Value[0]);
                        continue;
                    }
                    node.setProperty(key, values.toArray(new String[values.size()]));
                    continue;
                }
                if (propertyDefinition.getRequiredType() == 5) {
                    DateTime dateTime = ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(values.get(0));
                    node.setProperty(key, dateTime.toCalendar(Locale.ENGLISH));
                    continue;
                }
                node.setProperty(key, values.get(0));
            }
            session.save();
        }
        catch (CompositeConstraintViolationException compositeConstraintViolationException) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (ConstraintViolationException exception : compositeConstraintViolationException.getErrors()) {
                arrayList.add(this.getJSONConstraintError(exception));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("validationError", arrayList);
            return new ActionResult(400, null, jsonObject);
        }
        catch (ConstraintViolationException constraintViolationException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("validationError", Arrays.asList(this.getJSONConstraintError(constraintViolationException)));
            return new ActionResult(400, null, jSONObject);
        }
        catch (Exception exception) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("error", (Object)exception.getMessage());
            return new ActionResult(500, null, jSONObject);
        }
        if (req.getParameter("jcrAutoCheckin") != null && req.getParameter("jcrAutoCheckin").length() > 0) {
            session.getWorkspace().getVersionManager().checkpoint(node.getPath());
        }
        String string = "";
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            String string2 = httpSession.getId();
        }
        if (this.loggingService.isEnabled()) {
            void var10_19;
            this.loggingService.logContentEvent(renderContext.getUser().getName(), req.getRemoteAddr(), (String)var10_19, node.getIdentifier(), urlResolver.getPath(), primaryNodeTypeName, "nodeUpdated", new JSONObject(req.getParameterMap()).toString());
        }
        String requestWith = req.getHeader("x-requested-with");
        if (req.getHeader("accept") != null && req.getHeader("accept").contains("application/json") && requestWith != null && requestWith.equals("XMLHttpRequest")) {
            JSONObject jsonObject = null;
            try {
                jsonObject = Render.serializeNodeToJSON(node);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            return new ActionResult(200, node.getPath(), jsonObject);
        }
        return ActionResult.OK;
    }
}

