/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JahiaControllerUtils {
    private static final Logger logger = LoggerFactory.getLogger(JahiaControllerUtils.class);

    public static void checkUserAuthorized(JahiaUser user, String permissions) throws JahiaForbiddenAccessException {
        JahiaControllerUtils.checkUserAuthorized(null, user, permissions);
    }

    public static void checkUserAuthorized(JCRNodeWrapper node, JahiaUser user, String permissions) throws JahiaForbiddenAccessException {
        try {
            if (JahiaUserManagerService.isGuest(user)) {
                throw new JahiaUnauthorizedException("You need to authenticate yourself to use this service");
            }
            if (node != null ? !JahiaControllerUtils.hasRequiredPermission(node, user, permissions) : !JahiaControllerUtils.hasRequiredPermission(user, permissions)) {
                throw new JahiaForbiddenAccessException("You have not enough permissions to use this service");
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get permission", (Throwable)e);
            throw new JahiaForbiddenAccessException("You have not enough permissions to use this service");
        }
    }

    public static void checkUserLoggedIn(JahiaUser user) throws JahiaForbiddenAccessException {
        if (JahiaUserManagerService.isGuest(user)) {
            throw new JahiaUnauthorizedException("You need to authenticate yourself to use this service");
        }
    }

    public static final int getIntParameter(HttpServletRequest request, String name) throws JahiaBadRequestException {
        String value = request.getParameter(name);
        if (value == null) {
            throw new JahiaBadRequestException("Missing required '" + name + "' parameter in request.");
        }
        int param = 0;
        if (value != null) {
            try {
                param = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new JahiaBadRequestException(e);
            }
        }
        return param;
    }

    public static final int getIntParameter(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        int param = defaultValue;
        if (value != null) {
            try {
                param = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return param;
    }

    public static final String getParameter(HttpServletRequest request, String name) throws JahiaBadRequestException {
        String value = request.getParameter(name);
        if (value == null) {
            throw new JahiaBadRequestException("Missing required '" + name + "' parameter in request.");
        }
        return value;
    }

    public static final String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public static boolean hasRequiredPermission(JahiaUser user, String permissions) throws RepositoryException {
        return StringUtils.isNotEmpty((String)permissions) ? JahiaControllerUtils.hasRequiredPermission(JCRSessionFactory.getInstance().getCurrentUserSession().getRootNode(), user, permissions) : true;
    }

    public static boolean hasRequiredPermission(JCRNodeWrapper node, JahiaUser user, String permissions) throws RepositoryException {
        if (StringUtils.isEmpty((String)permissions)) {
            return true;
        }
        boolean hasPermission = false;
        if (permissions.contains("|") || permissions.contains("+")) {
            if (permissions.contains("|") && permissions.contains("+")) {
                throw new IllegalArgumentException("Unsupported permission format '" + permissions + "'");
            }
            boolean andOperator = permissions.contains("+");
            String[] parsedPermissions = andOperator ? Patterns.PLUS.split(permissions) : Patterns.PIPE.split(permissions);
            hasPermission = andOperator;
            for (String perm : parsedPermissions) {
                hasPermission = node.hasPermission(perm.trim());
                if (!(andOperator ? !hasPermission : hasPermission)) {
                    continue;
                }
                break;
            }
        } else {
            hasPermission = node.hasPermission(permissions);
        }
        return hasPermission;
    }

    private JahiaControllerUtils() {
    }
}

