/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.applications;

import java.io.Serializable;
import java.util.Locale;
import javax.portlet.PortletMode;
import org.jahia.services.applications.ApplicationsManagerServiceImpl;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPointInstance
implements Serializable {
    private static final long serialVersionUID = -8981953365965812339L;
    private static final transient Logger logger = LoggerFactory.getLogger(EntryPointInstance.class);
    private String ID;
    private String defName;
    private String contextName;
    private String resKeyName;
    private long expirationTime;
    private String cacheScope;

    public EntryPointInstance(String ID, String contextName, String definitionName) {
        this.defName = contextName + "." + definitionName;
        this.ID = ID;
        this.contextName = contextName;
    }

    public EntryPointInstance(String ID, String contextName, String definitionName, String resKeyName) {
        this.defName = contextName + "." + definitionName;
        this.ID = ID;
        this.contextName = contextName;
        this.resKeyName = resKeyName;
    }

    public String getID() {
        return this.ID;
    }

    public String getDefName() {
        return this.defName;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getResKeyName() {
        return this.resKeyName;
    }

    public void setResKeyName(String resKeyName) {
        this.resKeyName = resKeyName;
    }

    public String getDisplayName(Locale locale) {
        return this.resKeyName;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setCacheScope(String cacheScope) {
        this.cacheScope = cacheScope;
    }

    public String getCacheScope() {
        return this.cacheScope;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isUserInRole(JahiaUser user, String role, String workspaceName) {
        return JCRContentUtils.hasPermission(workspaceName, ApplicationsManagerServiceImpl.getWebAppQualifiedNodeName(this.contextName, role), this.ID);
    }

    public boolean isModeAllowed(JahiaUser user, String mode, String workspaceName) {
        if (mode != null && mode.equalsIgnoreCase(PortletMode.VIEW.toString())) {
            return true;
        }
        return JCRContentUtils.hasPermission(workspaceName, ApplicationsManagerServiceImpl.getPortletQualifiedNodeName(this.contextName, this.defName, mode), this.ID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryPointInstance that = (EntryPointInstance)o;
        return this.ID.equals(that.ID);
    }

    public int hashCode() {
        return this.ID.hashCode();
    }
}

