/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.applications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.ServletBean;
import org.jahia.utils.InsertionSortedMap;

public class WebAppContext
implements Serializable {
    private static final long serialVersionUID = 5206818081114734385L;
    private String displayName = "";
    private String context = "";
    private String descr = "";
    private InsertionSortedMap<String, ServletBean> servlets = new InsertionSortedMap();
    private static final Object servletsLock = new Object();
    private Map<String, String> servletMappings = new HashMap<String, String>();
    private static final Object mappingsLock = new Object();
    private List<String> roles = new ArrayList<String>();
    private static final Object rolesLock = new Object();
    private List<String> welcomeFiles = new ArrayList<String>();
    private static final Object welcomesLock = new Object();
    private List<EntryPointDefinition> entryPoints = new ArrayList<EntryPointDefinition>();

    public WebAppContext(String context) {
        this.context = context;
    }

    public WebAppContext(String context, String displayName, String descr, List<ServletBean> servlets, Map<String, String> servletMappings, List<String> roles, List<String> welcomeFiles) {
        this.context = context;
        if (displayName != null) {
            this.displayName = displayName;
        }
        if (descr != null) {
            this.descr = descr;
        }
        if (servlets != null) {
            this.addServlets(servlets);
        }
        if (servletMappings != null) {
            this.setServletMappings(servletMappings);
        }
        this.setRoles(roles);
        this.setWelcomeFiles(welcomeFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServlets(List<ServletBean> servlets) {
        Object object = servletsLock;
        synchronized (object) {
            if (servlets != null) {
                for (ServletBean servlet : servlets) {
                    if (servlet == null || servlet.getServletName() == null) continue;
                    this.servlets.put(servlet.getServletName(), servlet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServlet(ServletBean servlet) {
        Object object = servletsLock;
        synchronized (object) {
            if (servlet != null && servlet.getServletName() != null) {
                this.servlets.put(servlet.getServletName(), servlet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletBean getServlet(String name) {
        Object object = servletsLock;
        synchronized (object) {
            if (name != null) {
                return (ServletBean)this.servlets.get(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletMappings(Map<String, String> servletMappings) {
        Object object = mappingsLock;
        synchronized (object) {
            if (servletMappings != null) {
                this.servletMappings = servletMappings;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name) {
        Object object = mappingsLock;
        synchronized (object) {
            this.servletMappings.put(pattern, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findServletMapping(String pattern) {
        Object object = mappingsLock;
        synchronized (object) {
            return this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ServletBean> getServlets() {
        Object object = servletsLock;
        synchronized (object) {
            return this.servlets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoles(List<String> roles) {
        Object object = rolesLock;
        synchronized (object) {
            if (roles != null) {
                this.roles = roles;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRole(String role) {
        Object object = rolesLock;
        synchronized (object) {
            this.roles.add(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findRole(String role) {
        if (role == null) {
            return false;
        }
        Object object = rolesLock;
        synchronized (object) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRoles() {
        Object object = rolesLock;
        synchronized (object) {
            return this.roles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWelcomeFiles(List<String> welcomeFiles) {
        Object object = welcomesLock;
        synchronized (object) {
            if (welcomeFiles != null) {
                this.welcomeFiles = welcomeFiles;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWelcomeFile(String filename) {
        Object object = welcomesLock;
        synchronized (object) {
            this.welcomeFiles.add(filename);
        }
    }

    public List<EntryPointDefinition> getEntryPointDefinitions() {
        return this.entryPoints;
    }

    public void setEntryPointDefinitions(List<EntryPointDefinition> entryPointDefinitions) {
        this.entryPoints = entryPointDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWelcomeFiles() {
        Object object = welcomesLock;
        synchronized (object) {
            return this.welcomeFiles;
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String val) {
        this.context = val;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String val) {
        this.displayName = val;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String val) {
        this.descr = val;
    }
}

