/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.engines;

import java.io.Serializable;

public class EngineMessage
implements Serializable {
    private static final long serialVersionUID = 8836639382833159715L;
    private String key = null;
    private Object[] values = null;
    private boolean resource = true;

    public EngineMessage() {
    }

    public EngineMessage(String key) {
        this();
        this.key = key;
    }

    public EngineMessage(String key, boolean resource) {
        this(key);
        this.resource = resource;
    }

    public EngineMessage(String key, Object ... values) {
        this(key);
        this.values = values;
    }

    public EngineMessage(String key, String ... values) {
        this(key);
        this.values = values;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean isResource() {
        return this.resource;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.key);
        buff.append("[");
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                buff.append(this.values[i]);
                if (i >= this.values.length - 1) continue;
                buff.append(", ");
            }
        }
        buff.append("]");
        return buff.toString();
    }
}

