/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.impl.GenericPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AutoRegisteredBaseAuthValve
extends BaseAuthValve
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AutoRegisteredBaseAuthValve.class);
    private GenericPipeline authPipeline;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;

    public void afterPropertiesSet() {
        this.initialize();
        this.removeValve(this.authPipeline);
        this.addValve(this.authPipeline, this.position, this.positionAfter, this.positionBefore);
    }

    public void destroy() throws Exception {
        if (JahiaContextLoaderListener.isRunning()) {
            this.removeValve(this.authPipeline);
            logger.info("Unregistered authentication valve {}", (Object)this.getId());
        }
    }

    public void setAuthPipeline(GenericPipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }
}

