/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jahia.exceptions.JahiaException;
import org.jahia.osgi.FrameworkService;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.params.valves.BaseLoginEvent;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SsoValve
extends BaseAuthValve {
    private boolean fireLoginEvent = false;
    private static final Logger logger = LoggerFactory.getLogger(SsoValve.class);
    private boolean skipAuthentication = false;

    public void setFireLoginEvent(boolean fireLoginEvent) {
        this.fireLoginEvent = fireLoginEvent;
    }

    public abstract Object retrieveCredentials(HttpServletRequest var1) throws Exception;

    public abstract String validateCredentials(Object var1, HttpServletRequest var2) throws JahiaException;

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        Object credentials;
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("starting " + this.getClass().getName() + ".invoke()...");
        }
        AuthValveContext authContext = (AuthValveContext)context;
        JahiaUser sessionUser = null;
        HttpServletRequest servletRequest = authContext.getRequest();
        HttpSession session = servletRequest.getSession();
        if (session != null) {
            sessionUser = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
        }
        if (sessionUser != null && !JahiaUserManagerService.isGuest(sessionUser)) {
            if (logger.isDebugEnabled()) {
                logger.debug("user '{}' was already authenticated!", (Object)sessionUser.getUsername());
            }
            authContext.getSessionFactory().setCurrentUser(sessionUser);
            servletRequest.setAttribute("login_valve_result", (Object)"ok");
            return;
        }
        logger.debug("retrieving credentials...");
        try {
            credentials = this.retrieveCredentials(servletRequest);
        }
        catch (Exception e) {
            throw new PipelineException("exception was thrown while retrieving credentials!", e);
        }
        if (credentials != null) {
            String uid;
            if (logger.isDebugEnabled()) {
                logger.debug("credentials = {}", credentials);
            }
            logger.debug("validating credentials...");
            try {
                uid = this.validateCredentials(credentials, servletRequest);
            }
            catch (Exception e) {
                throw new PipelineException("exception was thrown while validating credentials!", e);
            }
            if (uid == null) {
                logger.warn("credentials were not validated!");
                servletRequest.setAttribute("login_valve_result", (Object)"bad_password");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("uid = {}", (Object)uid);
            }
            logger.debug("checking user existence in Jahia database...");
            JCRUserNode user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(uid);
            if (user == null) {
                servletRequest.setAttribute("login_valve_result", (Object)"unknown_user");
                throw new PipelineException("user '" + uid + "' was authenticated but not found in database!");
            }
            if (user.isAccountLocked()) {
                logger.warn("Login failed. Account is locked for user " + uid);
                servletRequest.setAttribute("login_valve_result", (Object)"account_locked");
                return;
            }
            JahiaUser jahiaUser = user.getJahiaUser();
            if (session != null) {
                servletRequest.getSession().invalidate();
                servletRequest.getSession().setAttribute("org.jahia.usermanager.jahiauser", (Object)jahiaUser);
            }
            authContext.getSessionFactory().setCurrentUser(jahiaUser);
            servletRequest.setAttribute("login_valve_result", (Object)"ok");
            if (this.fireLoginEvent) {
                SpringContextSingleton.getInstance().publishEvent(new LoginEvent(this, jahiaUser, authContext));
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("user", jahiaUser);
                m.put("authContext", authContext);
                m.put("source", this);
                FrameworkService.sendEvent("org/jahia/usersgroups/login/LOGIN", m, false);
            }
            return;
        }
        logger.debug("no credentials found!");
        if (!this.isSkipAuthentication()) {
            valveContext.invokeNext(context);
        }
    }

    public abstract String getRedirectUrl(HttpServletRequest var1) throws JahiaException;

    public boolean isSkipAuthentication() {
        return this.skipAuthentication;
    }

    public void setSkipAuthentication(boolean skipAuthentication) {
        this.skipAuthentication = skipAuthentication;
    }

    public class LoginEvent
    extends BaseLoginEvent {
        public LoginEvent(Object source, JahiaUser jahiaUser, AuthValveContext authValveContext) {
            super(source, jahiaUser, authValveContext);
        }
    }
}

