/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.params.valves;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.IdentifierGeneratorFactory;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.services.usermanager.JahiaUser;

public class TokenAuthValveImpl
extends BaseAuthValve {
    private static IdentifierGenerator idGen = IdentifierGeneratorFactory.newInstance().uuidVersionFourGenerator();
    private static Map<String, JahiaUser> map = new ConcurrentHashMap<String, JahiaUser>();

    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        JahiaUser jahiaUser;
        if (!this.isEnabled()) {
            valveContext.invokeNext(context);
            return;
        }
        AuthValveContext authContext = (AuthValveContext)context;
        HttpServletRequest request = authContext.getRequest();
        if (request.getHeader("jahiatoken") != null && (jahiaUser = map.remove(request.getHeader("jahiatoken"))) != null) {
            authContext.getSessionFactory().setCurrentUser(jahiaUser);
            return;
        }
        valveContext.invokeNext(context);
    }

    public static String addToken(JahiaUser user) {
        String s = idGen.nextIdentifier().toString();
        map.put(s, user);
        return s;
    }
}

