/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jahia.bin.Jahia;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.usermanager.JahiaUser;

public class JahiaContextRequest
extends HttpServletRequestWrapper {
    private JahiaUser jahiaUser;
    private String workspaceName;
    private String pathInfo = null;
    private String queryString = null;
    private String servletPath = null;
    private EntryPointInstance entryPointInstance;

    public JahiaContextRequest(JahiaUser jahiaUser, HttpServletRequest httpServletRequest, String workspaceName) throws JahiaException {
        super(httpServletRequest);
        this.jahiaUser = jahiaUser;
        this.workspaceName = workspaceName;
        if (Jahia.getServletPath() != null && !Jahia.getServletPath().equals(this.getServletPath())) {
            this.setServletPath(Jahia.getServletPath());
            this.setPathInfo(httpServletRequest.getPathInfo());
            this.setQueryString(httpServletRequest.getQueryString());
        }
    }

    public String getServletPath() {
        if (this.servletPath == null) {
            return super.getServletPath();
        }
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getPathInfo() {
        if (this.pathInfo == null) {
            return super.getPathInfo();
        }
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            return super.getQueryString();
        }
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.getPathInfo();
    }

    public String getRemoteUser() {
        return this.jahiaUser.getUserKey();
    }

    public Principal getUserPrincipal() {
        return this.jahiaUser;
    }

    public void setEntryPointInstance(EntryPointInstance entryPointInstance) {
        this.entryPointInstance = entryPointInstance;
    }

    public boolean isUserInRole(String role) {
        if (this.entryPointInstance == null) {
            return false;
        }
        return this.entryPointInstance.isUserInRole(this.jahiaUser, role, this.workspaceName);
    }
}

