/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.applications.pluto;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;
import org.apache.pluto.driver.url.impl.PortalURLParserImpl;
import org.apache.pluto.driver.url.impl.RelativePortalURLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPortalURLParserImpl
implements PortalURLParser {
    private static final Logger LOG = LoggerFactory.getLogger(PortalURLParserImpl.class);
    private static final PortalURLParser PARSER = new JahiaPortalURLParserImpl();
    private static final PortalURLParser DEFAULT_PARSER = PortalURLParserImpl.getParser();
    private static final String PREFIX = "__";
    private static final String DELIM = "_";
    private static final String PORTLET_ID = "pd";
    private static final String ACTION = "ac";
    private static final String RESOURCE = "rs";
    private static final String RESOURCE_ID = "ri";
    private static final String CACHE_LEVEL = "cl";
    private static final String RENDER_PARAM = "rp";
    private static final String PRIVATE_RENDER_PARAM = "pr";
    private static final String PUBLIC_RENDER_PARAM = "sp";
    private static final String WINDOW_STATE = "ws";
    private static final String PORTLET_MODE = "pm";
    private static final String VALUE_DELIM = "0x0";
    private static final Pattern VALUE_DELIM_PATTERN = Pattern.compile("0x0");
    private static final String[][] ENCODINGS = new String[][]{{"_", "0x1"}, {".", "0x2"}, {"/", "0x3"}, {"\r", "0x4"}, {"\n", "0x5"}, {"<", "0x6"}, {">", "0x7"}, {" ", "0x8"}, {"#", "0x9"}, {"?", "0xa"}, {"\\", "0xb"}, {"%", "0xc"}};
    public static final String PORTLET_INFO = "portletInfo";

    private JahiaPortalURLParserImpl() {
    }

    public static PortalURLParser getParser() {
        return PARSER;
    }

    public PortalURL parse(HttpServletRequest request) {
        String urlBase = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
        String contextPath = request.getContextPath();
        String servletName = request.getServletPath();
        String pathInfo = request.getPathInfo();
        return this.parse(urlBase, contextPath, servletName, pathInfo, request.getParameter(PORTLET_INFO));
    }

    private PortalURL parse(String urlBase, String contextPath, String servletName, String pathInfo, String portletInfo) {
        RelativePortalURLImpl portalURL = new RelativePortalURLImpl(urlBase, contextPath, servletName + pathInfo, (PortalURLParser)this);
        if (portletInfo == null) {
            if (servletName.contains(".jsp") && !servletName.endsWith(".jsp")) {
                int idx = servletName.indexOf(".jsp") + ".jsp".length();
                portletInfo = servletName.substring(idx);
                servletName = servletName.substring(0, idx);
                portalURL = new RelativePortalURLImpl(urlBase, contextPath, servletName, (PortalURLParser)this);
            } else {
                return portalURL;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing request pathInfo: " + portletInfo);
        }
        StringBuilder renderPath = new StringBuilder();
        StringTokenizer st = new StringTokenizer(portletInfo, "/", false);
        while (st.hasMoreTokens()) {
            PortalURLParameter param;
            String value;
            String[] decoded;
            String token = st.nextToken();
            if (!token.startsWith(PREFIX)) {
                renderPath.append('/').append(token);
                continue;
            }
            if (token.startsWith("__rs")) {
                portalURL.setResourceWindow(this.decodeControlParameter(token)[0]);
                continue;
            }
            if (token.startsWith("__ac")) {
                portalURL.setActionWindow(this.decodeControlParameter(token)[0]);
                continue;
            }
            if (token.startsWith("__cl")) {
                portalURL.setCacheability(this.decodeControlParameter(token)[0]);
                continue;
            }
            if (token.startsWith("__ri")) {
                portalURL.setResourceID(this.decodeControlParameter(token)[0]);
                continue;
            }
            if (token.startsWith("__ws")) {
                decoded = this.decodeControlParameter(token);
                portalURL.setWindowState(decoded[0], new WindowState(decoded[1]));
                continue;
            }
            if (token.startsWith("__pm")) {
                decoded = this.decodeControlParameter(token);
                portalURL.setPortletMode(decoded[0], new PortletMode(decoded[1]));
                continue;
            }
            if (token.startsWith("__rp")) {
                value = null;
                if (st.hasMoreTokens()) {
                    value = st.nextToken();
                }
                param = this.decodeParameter(token, value);
                portalURL.addParameter(param);
                continue;
            }
            if (token.startsWith("__pr")) {
                value = null;
                if (st.hasMoreTokens()) {
                    value = st.nextToken();
                }
                if ((param = this.decodePublicParameter(token, value)) == null) continue;
                portalURL.getPrivateRenderParameters().put(param.getName(), param.getValues());
                continue;
            }
            if (!token.startsWith("__sp")) continue;
            value = null;
            if (st.hasMoreTokens()) {
                value = st.nextToken();
            }
            if ((param = this.decodePublicParameter(token, value)) == null) continue;
            portalURL.addPublicParameterCurrent(param.getName(), param.getValues());
        }
        if (renderPath.length() > 0) {
            portalURL.setRenderPath(renderPath.toString());
        }
        return portalURL;
    }

    public String toString(PortalURL portalURL) {
        StringBuilder buffer = new StringBuilder();
        return buffer.append(StringUtils.substringAfterLast((String)portalURL.getServletPath(), (String)"/")).append("?").append(PORTLET_INFO).append("=").append(this.toPortletPathInfo(portalURL).replace('?', '&')).toString();
    }

    private String toPortletPathInfo(PortalURL portalURL) {
        Map publicParamList;
        String valueString;
        String[] tmp;
        Map privateParamList;
        StringBuffer buffer = new StringBuffer();
        if (portalURL.getRenderPath() != null) {
            buffer.append(portalURL.getRenderPath());
        }
        if (portalURL.getResourceWindow() != null) {
            buffer.append("/");
            buffer.append(PREFIX).append(RESOURCE).append(this.encodeCharacters(portalURL.getResourceWindow()));
        }
        if (portalURL.getActionWindow() != null) {
            buffer.append("/");
            buffer.append(PREFIX).append(ACTION).append(this.encodeCharacters(portalURL.getActionWindow()));
        }
        if (portalURL.getResourceWindow() != null) {
            if (portalURL.getCacheability() != null) {
                buffer.append("/");
                buffer.append(PREFIX).append(CACHE_LEVEL).append(this.encodeCharacters(portalURL.getCacheability()));
            }
            if (portalURL.getResourceID() != null) {
                buffer.append("/");
                buffer.append(PREFIX).append(RESOURCE_ID).append(this.encodeCharacters(portalURL.getResourceID()));
            }
        }
        for (Map.Entry entry : portalURL.getPortletModes().entrySet()) {
            buffer.append("/").append(this.encodeControlParameter(PORTLET_MODE, entry.getKey().toString(), entry.getValue().toString()));
        }
        for (Map.Entry entry : portalURL.getWindowStates().entrySet()) {
            buffer.append("/").append(this.encodeControlParameter(WINDOW_STATE, entry.getKey().toString(), entry.getValue().toString()));
        }
        StringBuilder query = new StringBuilder("?");
        boolean firstParam = true;
        for (PortalURLParameter param : portalURL.getParameters()) {
            String valueString2;
            if (portalURL.getActionWindow() != null && portalURL.getActionWindow().equals(param.getWindowId()) || portalURL.getResourceWindow() != null && portalURL.getResourceWindow().equals(param.getWindowId())) {
                for (int i = 0; i < param.getValues().length; ++i) {
                    if (firstParam) {
                        firstParam = false;
                    } else {
                        query.append("&");
                    }
                    query.append(this.encodeQueryParam(param.getName())).append("=").append(this.encodeQueryParam(param.getValues()[i]));
                }
                continue;
            }
            if (param.getValues() == null || param.getValues().length <= 0 || (valueString2 = this.encodeMultiValues(param.getValues())).length() <= 0) continue;
            buffer.append("/").append(this.encodeControlParameter(RENDER_PARAM, param.getWindowId(), param.getName()));
            buffer.append("/").append(valueString2);
        }
        JahiaPortalURLParserImpl.encode(buffer);
        if (portalURL.getResourceWindow() != null && (privateParamList = portalURL.getPrivateRenderParameters()) != null) {
            for (String paramname : privateParamList.keySet()) {
                tmp = (String[])privateParamList.get(paramname);
                valueString = this.encodeMultiValues(tmp);
                if (valueString.length() <= 0) continue;
                buffer.append("/").append(this.encodePublicParamname(PRIVATE_RENDER_PARAM, paramname));
                buffer.append("/").append(valueString);
            }
        }
        if ((publicParamList = portalURL.getPublicParameters()) != null) {
            for (String paramname : publicParamList.keySet()) {
                tmp = (String[])publicParamList.get(paramname);
                valueString = this.encodeMultiValues(tmp);
                if (valueString.length() <= 0) continue;
                buffer.append("/").append(this.encodePublicParamname(PUBLIC_RENDER_PARAM, paramname));
                buffer.append("/").append(valueString);
            }
        }
        if (query.length() > 1) {
            return buffer.append((CharSequence)query).toString();
        }
        return buffer.append((CharSequence)query).toString();
    }

    public static void encode(StringBuffer url) {
        JahiaPortalURLParserImpl.replaceChar(url, "|", "%7C");
        JahiaPortalURLParserImpl.replaceChar(url, "\"", "%22");
    }

    private static void replaceChar(StringBuffer url, String character, String change) {
        boolean contains = url.toString().contains(character);
        while (contains) {
            int index = url.indexOf(character);
            url.deleteCharAt(index);
            url.insert(index, change, 0, 3);
            contains = url.toString().contains(character);
        }
    }

    private String encodeQueryParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeControlParameter(String type, String windowId, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(PREFIX).append(type).append(this.encodeCharacters(windowId)).append(DELIM).append(name);
        return buffer.toString();
    }

    private String encodePublicParamname(String type, String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(PREFIX).append(type).append(DELIM).append(name);
        return buffer.toString();
    }

    private String encodeMultiValues(String[] values) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String currentValue = values[i];
            try {
                if (currentValue != null) {
                    currentValue = URLEncoder.encode(values[i], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            buffer.append(currentValue != null ? currentValue : "");
            if (i + 1 >= values.length) continue;
            buffer.append(VALUE_DELIM);
        }
        return this.encodeCharacters(buffer.toString());
    }

    private String encodeCharacters(String string) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            string = string.replace(ENCODINGS[i][0], ENCODINGS[i][1]);
        }
        return string;
    }

    private String[] decodeControlParameter(String control) {
        String[] valuePair = new String[2];
        int index = (control = control.substring("__pd".length())).indexOf(DELIM);
        if (index >= 0) {
            valuePair[0] = control.substring(0, index);
            valuePair[0] = this.decodeCharacters(valuePair[0]);
            if (index + 1 <= control.length()) {
                valuePair[1] = control.substring(index + 1);
                valuePair[1] = this.decodeCharacters(valuePair[1]);
            } else {
                valuePair[1] = "";
            }
        } else {
            valuePair[0] = this.decodeCharacters(control);
        }
        return valuePair;
    }

    private PortalURLParameter decodeParameter(String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decoding parameter: name=" + name + ", value=" + value);
        }
        String noPrefix = name.substring("__pd".length());
        String windowId = noPrefix.substring(0, noPrefix.indexOf(DELIM));
        String paramName = noPrefix.substring(noPrefix.indexOf(DELIM) + 1);
        windowId = this.decodeCharacters(windowId);
        if (value != null) {
            value = this.decodeCharacters(value);
        }
        String[] paramValues = VALUE_DELIM_PATTERN.split(value);
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                paramValues[i] = URLDecoder.decode(paramValues[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return new PortalURLParameter(windowId, paramName, paramValues);
    }

    private PortalURLParameter decodePublicParameter(String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decoding parameter: name=" + name + ", value=" + value);
        }
        String noPrefix = name.substring("__pd".length());
        String paramName = noPrefix.substring(noPrefix.indexOf(DELIM) + 1);
        if (value != null) {
            value = this.decodeCharacters(value);
        }
        String[] paramValues = VALUE_DELIM_PATTERN.split(value);
        return new PortalURLParameter(null, paramName, paramValues);
    }

    private String decodeCharacters(String string) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            string = string.replace(ENCODINGS[i][1], ENCODINGS[i][0]);
        }
        return string;
    }
}

