/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.cache.ClassLoaderAwareCacheEntry;

public class ModuleClassLoaderAwareCacheEntry
extends ClassLoaderAwareCacheEntry {
    private static final long serialVersionUID = -4281419239864698107L;
    private transient String moduleName;

    public ModuleClassLoaderAwareCacheEntry(Object value, String moduleName) {
        super(value);
        this.moduleName = moduleName;
    }

    @Override
    protected void beforeReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.moduleName = (String)in.readObject();
    }

    @Override
    protected void beforeWriteObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.moduleName);
    }

    @Override
    protected ClassLoader getClassLoaderToUse() {
        JahiaTemplatesPackage module = this.moduleName != null ? ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.moduleName) : null;
        return module != null ? module.getClassLoader() : null;
    }
}

