/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildNodesIterator
implements JCRNodeIteratorWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ChildNodesIterator.class);
    private NodeIterator ni;
    private List<String> mountNames;
    private List<JCRNodeWrapper> mountNodes;
    private JCRNodeWrapperImpl parent;
    private JCRSessionWrapper session;
    private JCRStoreProvider provider;
    private JCRNodeWrapper nextNode;
    private long position;
    private List<JCRNodeWrapper> cache = new ArrayList<JCRNodeWrapper>();

    public ChildNodesIterator(NodeIterator ni, List<String> mountNames, List<JCRNodeWrapper> mountNodes, JCRNodeWrapperImpl parent, JCRSessionWrapper session, JCRStoreProvider provider) {
        this.ni = ni;
        this.mountNames = mountNames;
        this.mountNodes = mountNodes;
        this.parent = parent;
        this.session = session;
        this.provider = provider;
        this.position = 0L;
        this.prefetchNext();
    }

    private JCRNodeWrapper loadNextInCache() {
        while (true) {
            try {
                while (true) {
                    if (this.mountNodes != null && !this.mountNodes.isEmpty()) {
                        JCRNodeWrapper wrapper = this.mountNodes.remove(0);
                        this.cache.add(wrapper);
                        return wrapper;
                    }
                    Node n = null;
                    while (n == null && this.ni.hasNext()) {
                        n = this.ni.nextNode();
                        if ((this.session.getLocale() == null || !n.getName().startsWith("j:translation_")) && (this.mountNames == null || !this.mountNames.contains(n.getName()))) continue;
                        n = null;
                    }
                    if (n == null) break;
                    try {
                        JCRNodeWrapper wrapper = this.provider.getNodeWrapper(n, this.parent.buildSubnodePath(n.getName()), this.parent, this.session);
                        this.cache.add(wrapper);
                        return wrapper;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        continue;
                    }
                    break;
                }
                return null;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void prefetchNext() {
        while (this.position >= (long)this.cache.size() && this.loadNextInCache() != null) {
        }
        if (this.position < (long)this.cache.size()) {
            this.nextNode = this.cache.get((int)this.position);
            ++this.position;
        } else {
            this.nextNode = null;
        }
    }

    public void skip(long skipNum) {
        int i = 0;
        while ((long)i < skipNum) {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            this.prefetchNext();
            ++i;
        }
    }

    public long getSize() {
        while (this.loadNextInCache() != null) {
        }
        return this.cache.size();
    }

    public long getPosition() {
        return this.hasNext() ? this.position - 1L : this.position;
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Object next() {
        return this.wrappedNext();
    }

    private JCRNodeWrapper wrappedNext() {
        JCRNodeWrapper res = this.nextNode;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.prefetchNext();
        return res;
    }

    public void remove() {
        if (this.mountNodes != null && !this.mountNodes.isEmpty()) {
            this.mountNodes.remove(0);
        } else {
            this.ni.remove();
        }
    }

    @Override
    public Iterator<JCRNodeWrapper> iterator() {
        return new Iterator<JCRNodeWrapper>(){

            @Override
            public boolean hasNext() {
                return ChildNodesIterator.this.hasNext();
            }

            @Override
            public JCRNodeWrapper next() {
                return ChildNodesIterator.this.wrappedNext();
            }

            @Override
            public void remove() {
                ChildNodesIterator.this.remove();
            }
        };
    }
}

