/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.AdditionalEventInfo;
import org.jahia.services.content.ApiEvent;
import org.jahia.services.content.ApiEventListener;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRWorkspaceWrapper;
import org.jahia.services.content.RangeIteratorImpl;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRObservationManager
implements ObservationManager {
    public static final int SESSION_SAVE = 1;
    public static final int WORKSPACE_MOVE = 2;
    public static final int WORKSPACE_COPY = 3;
    public static final int WORKSPACE_CLONE = 4;
    public static final int WORKSPACE_CREATE_ACTIVITY = 5;
    public static final int NODE_CHECKIN = 6;
    public static final int NODE_CHECKOUT = 7;
    public static final int NODE_CHECKPOINT = 8;
    public static final int NODE_RESTORE = 9;
    public static final int NODE_UPDATE = 10;
    public static final int NODE_MERGE = 11;
    public static final int EXTERNAL_SYNC = 12;
    public static final int IMPORT = 13;
    public static final int API = 14;
    private static final Logger logger = LoggerFactory.getLogger(JCRObservationManager.class);
    private static ThreadLocal<Integer> eventListenersAvailableDuringPublishOnly = new ThreadLocal();
    private static ThreadLocal<Boolean> allEventListenersDisabled = new ThreadLocal();
    private static ThreadLocal<JCRSessionWrapper> currentSession = new ThreadLocal();
    private static ThreadLocal<Integer> lastOp = new ThreadLocal();
    private static ThreadLocal<Map<JCRSessionWrapper, List<EventWrapper>>> events = new ThreadLocal();
    private static List<EventConsumer> listeners = new CopyOnWriteArrayList<EventConsumer>();
    private JCRWorkspaceWrapper ws;

    public JCRObservationManager(JCRWorkspaceWrapper ws) {
        this.ws = ws;
    }

    public static void consume(List<EventWrapper> list, JCRSessionWrapper session, int operationType, int lastOperationType) throws RepositoryException {
        if (Boolean.TRUE.equals(allEventListenersDisabled.get())) {
            return;
        }
        String wspName = session.getWorkspace().getName();
        boolean duringPublicationOnly = eventListenersAvailableDuringPublishOnly.get() != null && eventListenersAvailableDuringPublishOnly.get() > 0;
        for (EventConsumer consumer : listeners) {
            DefaultEventListener castListener;
            DefaultEventListener defaultEventListener = castListener = consumer.listener instanceof DefaultEventListener ? (DefaultEventListener)consumer.listener : null;
            if (!consumer.session.getWorkspace().getName().equals(wspName) || duringPublicationOnly && castListener != null && !castListener.isAvailableDuringPublish() || !consumer.useExternalEvents && operationType == 12 || !consumer.useApiEvents && operationType == 14) continue;
            ArrayList<EventWrapper> filteredEvents = new ArrayList<EventWrapper>();
            for (EventWrapper event : list) {
                if ((consumer.eventTypes & event.getType()) == 0 || consumer.pathPattern != null && !consumer.pathPattern.matcher(event.getPath()).matches() || consumer.uuid != null && !JCRObservationManager.checkUuids(event.getIdentifier(), consumer.uuid) || castListener != null && !castListener.isSupportedOperationType(operationType) || consumer.nodeTypeName != null && !JCRObservationManager.checkNodeTypeNames(session, event, consumer.nodeTypeName)) continue;
                filteredEvents.add(event);
            }
            try {
                if (filteredEvents.isEmpty()) continue;
                consumer.listener.onEvent((EventIterator)new JCREventIterator(session, operationType, lastOperationType, filteredEvents.iterator(), filteredEvents.size()));
            }
            catch (Exception e) {
                logger.warn("Error processing event by listener. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void removeEventListener(EventListener listener) throws RepositoryException {
        EventConsumer e = null;
        for (EventConsumer eventConsumer : listeners) {
            if (eventConsumer.listener != listener) continue;
            e = eventConsumer;
            break;
        }
        if (e != null) {
            listeners.remove(e);
        }
    }

    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        return new EventListenerIteratorImpl(listeners.iterator(), listeners.size());
    }

    public void setUserData(String userData) throws RepositoryException {
    }

    public EventJournal getEventJournal() throws RepositoryException {
        return null;
    }

    public EventJournal getEventJournal(int i, String s, boolean b, String[] strings, String[] strings1) throws RepositoryException {
        return null;
    }

    @Deprecated
    public static void setEventListenersAvailableDuringPublishOnly(Boolean eventsDisabled) {
        if (eventsDisabled != null && eventsDisabled.booleanValue()) {
            JCRObservationManager.pushEventListenersAvailableDuringPublishOnly();
        } else {
            JCRObservationManager.popEventListenersAvailableDuringPublishOnly();
        }
    }

    public static void pushEventListenersAvailableDuringPublishOnly() {
        Integer previous = eventListenersAvailableDuringPublishOnly.get();
        if (previous == null) {
            previous = 0;
        }
        eventListenersAvailableDuringPublishOnly.set(previous + 1);
    }

    public static void popEventListenersAvailableDuringPublishOnly() {
        Integer previous = eventListenersAvailableDuringPublishOnly.get();
        if (previous == null || previous == 0) {
            throw new RuntimeException("Cannot pop observer flag");
        }
        eventListenersAvailableDuringPublishOnly.set(previous - 1);
    }

    public static void setAllEventListenersDisabled(Boolean eventsDisabled) {
        allEventListenersDisabled.set(eventsDisabled);
    }

    public static void addEvent(Event event, String mountPoint, String relativeRoot) {
        try {
            if (!event.getPath().startsWith("/jcr:system") && (event.getPath().equals(relativeRoot) || event.getPath().startsWith(relativeRoot + '/'))) {
                if (event.getType() == 1 && JCRObservationManager.isExtensionNode(event.getPath()) && JCRObservationManager.hasMatchingUuidBeenSet(event.getPath())) {
                    return;
                }
                Map<JCRSessionWrapper, List<EventWrapper>> map = events.get();
                if (map == null) {
                    events.set(new HashMap());
                }
                map = events.get();
                JCRSessionWrapper session = currentSession.get();
                if (session != null) {
                    if (!map.containsKey(session)) {
                        map.put(session, new ArrayList());
                    }
                    List<EventWrapper> list = map.get(session);
                    list.add(JCRObservationManager.getEventWrapper(event, session, mountPoint, relativeRoot));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static EventWrapper getEventWrapper(Event event, JCRSessionWrapper session, String mountPoint, String relativeRoot) {
        return new EventWrapper(event, event.getType() != 2 ? null : JCRObservationManager.getNodeTypesForRemovedNode(event, session), mountPoint, relativeRoot, session);
    }

    private static List<String> getNodeTypesForRemovedNode(Event event, JCRSessionWrapper session) {
        LinkedList<String> typeNames = new LinkedList<String>();
        try {
            NamespaceRegistry nsRegistry = session.getWorkspace().getNamespaceRegistry();
            String ntName = null;
            Map info = event.getInfo();
            if (info != null && !info.isEmpty()) {
                String mixins;
                ntName = (String)info.get("primaryType");
                if (ntName != null) {
                    typeNames.add(JCRContentUtils.getJCRName(ntName, nsRegistry));
                }
                if ((mixins = (String)info.get("mixinTypes")) != null && mixins.length() > 0) {
                    if (mixins.indexOf(32) == -1) {
                        typeNames.add(JCRContentUtils.getJCRName(mixins, nsRegistry));
                    } else {
                        for (String m : StringUtils.split((String)mixins, (char)' ')) {
                            typeNames.add(JCRContentUtils.getJCRName(m, nsRegistry));
                        }
                    }
                }
            }
            if (ntName == null && event instanceof AdditionalEventInfo) {
                AdditionalEventInfo advEvent = (AdditionalEventInfo)event;
                ntName = advEvent.getPrimaryNodeTypeName().toString();
                typeNames.add(JCRContentUtils.getJCRName(ntName, nsRegistry));
                if (typeNames.size() == 1) {
                    for (Name name : advEvent.getMixinTypeNames()) {
                        typeNames.add(JCRContentUtils.getJCRName(name.toString(), nsRegistry));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot parse type for event " + event, (Throwable)e);
            }
            logger.warn("Cannot parse type for event {}. Cause: {}", (Object)event, (Object)e.getMessage());
        }
        return typeNames;
    }

    private static void consume(JCRSessionWrapper session, int lastOperationType) throws RepositoryException {
        int operationType = lastOp.get();
        Map<JCRSessionWrapper, List<EventWrapper>> map = events.get();
        events.set(null);
        currentSession.set(null);
        if (map != null && map.containsKey(session)) {
            List<EventWrapper> list = map.get(session);
            JCRObservationManager.consume(list, session, operationType, lastOperationType);
        }
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        listeners.add(new EventConsumer(this.ws.getSession(), listener, eventTypes, absPath, isDeep, nodeTypeName, uuid, listener instanceof ExternalEventListener, listener instanceof ApiEventListener));
    }

    private static boolean checkNodeTypeNames(JCRSessionWrapper session, EventWrapper event, String[] requiredNodeTypes) throws RepositoryException {
        if (event.getNodeTypes() == null) {
            String nodePath = event.getType() == 8 || event.getType() == 16 || event.getType() == 4 ? StringUtils.substringBeforeLast((String)event.getPath(), (String)"/") : event.getPath();
            try {
                JCRNodeWrapper node = session.getNode(nodePath);
                event.setNodeTypes(node.getNodeTypes());
            }
            catch (RepositoryException e) {
                logger.debug("Could not retrieve node (type)", (Throwable)e);
                event.setNodeTypes(Collections.emptyList());
            }
        }
        if (event.getNodeTypes() != null && requiredNodeTypes.length > 0) {
            NodeTypeRegistry ntRegistry = NodeTypeRegistry.getInstance();
            for (String requiredNodeType : requiredNodeTypes) {
                for (String nodeType : event.getNodeTypes()) {
                    ExtendedNodeType nt = ntRegistry.getNodeType(nodeType, false);
                    if (nt == null || !nt.isNodeType(requiredNodeType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkUuids(String identifier, String[] uuids) throws RepositoryException {
        if (identifier != null) {
            for (String uuid : uuids) {
                if (!identifier.equals(uuid)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> X doWorkspaceWriteCall(JCRSessionWrapper session, int operationType, JCRCallback<X> callback) throws RepositoryException {
        boolean x;
        X res;
        session.checkReadOnly(operationType + " operation is not permitted for the current session as it is in read-only mode");
        currentSession.set(session);
        try {
            res = callback.doInJCR(session);
            x = lastOp.get() == null;
        }
        catch (Throwable throwable) {
            boolean x2 = lastOp.get() == null;
            try {
                if (x2) {
                    lastOp.set(operationType);
                }
                JCRObservationManager.consume(session, operationType);
            }
            finally {
                currentSession.set(null);
                if (x2) {
                    lastOp.set(null);
                }
            }
            throw throwable;
        }
        try {
            if (x) {
                lastOp.set(operationType);
            }
            JCRObservationManager.consume(session, operationType);
        }
        finally {
            currentSession.set(null);
            if (x) {
                lastOp.set(null);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> X doWithOperationType(JCRSessionWrapper session, int operationType, JCRCallback<X> callback) throws RepositoryException {
        boolean x = lastOp.get() == null;
        try {
            if (x) {
                lastOp.set(operationType);
            }
            X x2 = callback.doInJCR(session);
            return x2;
        }
        finally {
            currentSession.set(null);
            if (x) {
                lastOp.set(null);
            }
        }
    }

    public static Integer getCurrentOperationType() {
        return lastOp.get();
    }

    public static boolean isExtensionNode(String path) throws RepositoryException {
        return JCRSessionFactory.getInstance().getProvider(path, false) != null;
    }

    private static boolean hasMatchingUuidBeenSet(String path) throws RepositoryException {
        if (events.get() != null && currentSession.get() != null) {
            List<EventWrapper> currentEvents = events.get().get(currentSession.get());
            for (EventWrapper previousEvent : currentEvents) {
                if (!previousEvent.getPath().equals(path + "/j:externalNodeIdentifier")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getNodeTypesForDeletedNode(Event event) {
        return event instanceof EventWrapper ? ((EventWrapper)event).getNodeTypes() : null;
    }

    public static class EventWrapper
    implements Event {
        private Event event;
        private List<String> nodeTypes;
        private String identifier;
        private JCRSessionWrapper session;
        private String mountPoint;
        private String relativeRoot;
        private String effectivePath;

        EventWrapper(Event event, List<String> nodeTypes, String mountPoint, String relativeRoot, JCRSessionWrapper session) {
            this.event = event;
            this.nodeTypes = nodeTypes;
            this.session = session;
            this.mountPoint = mountPoint;
            this.relativeRoot = relativeRoot;
        }

        public int getType() {
            return this.event.getType();
        }

        public String getPath() throws RepositoryException {
            if (this.effectivePath == null) {
                this.effectivePath = !this.mountPoint.equals("/") ? this.mountPoint + (this.event.getPath().equals("/") ? "" : this.event.getPath()).substring(this.relativeRoot.length()) : this.event.getPath();
            }
            return this.effectivePath;
        }

        public String getUserID() {
            return this.event.getUserID();
        }

        public String getIdentifier() throws RepositoryException {
            if (this.identifier == null) {
                if (JCRObservationManager.isExtensionNode(this.getPath())) {
                    String path = this.getPath();
                    if (this.event.getType() == 4 || this.event.getType() == 8 || this.event.getType() == 16) {
                        path = StringUtils.substringBeforeLast((String)path, (String)"/");
                    }
                    try {
                        this.identifier = this.session.getNode(path).getIdentifier();
                    }
                    catch (RepositoryException e) {
                        this.identifier = null;
                    }
                } else {
                    this.identifier = this.event.getIdentifier();
                }
            }
            return this.identifier;
        }

        public Map getInfo() throws RepositoryException {
            return this.event.getInfo();
        }

        public String getUserData() throws RepositoryException {
            return this.event.getUserData();
        }

        public long getDate() throws RepositoryException {
            return this.event.getDate();
        }

        public void setNodeTypes(List<String> nodeTypes) {
            this.nodeTypes = nodeTypes;
        }

        public List<String> getNodeTypes() {
            return this.nodeTypes;
        }

        public boolean isExternal() {
            return this.event instanceof JackrabbitEvent ? ((JackrabbitEvent)this.event).isExternal() : false;
        }

        public boolean isApiEvent() {
            return this.event instanceof ApiEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.event.equals(((EventWrapper)o).event);
        }

        public int hashCode() {
            return this.event != null ? this.event.hashCode() : 0;
        }

        public String toString() {
            return this.event.toString();
        }
    }

    class EventListenerIteratorImpl
    extends RangeIteratorImpl
    implements EventListenerIterator {
        EventListenerIteratorImpl(Iterator<EventConsumer> iterator, long size) {
            super(iterator, size);
        }

        public EventListener nextEventListener() {
            return ((EventConsumer)this.next()).listener;
        }
    }

    class EventConsumer {
        private JCRSessionWrapper session;
        private EventListener listener;
        private int eventTypes;
        private String absPath;
        private boolean isDeep;
        private String[] nodeTypeName;
        private String[] uuid;
        private boolean useExternalEvents;
        private boolean useApiEvents;
        private Pattern pathPattern;

        EventConsumer(JCRSessionWrapper session, EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] nodeTypeName, String[] uuid, boolean useExternalEvents, boolean useApiEvents) {
            this.session = session;
            this.listener = listener;
            this.eventTypes = eventTypes;
            this.absPath = absPath;
            this.isDeep = isDeep;
            this.nodeTypeName = nodeTypeName;
            this.uuid = uuid;
            this.useExternalEvents = useExternalEvents;
            this.useApiEvents = useApiEvents;
            if (this.absPath != null) {
                this.pathPattern = Pattern.compile("^" + this.absPath + (this.isDeep ? (this.absPath.endsWith("/") ? "(.*)*" : "(/.*)*") : "") + "$");
            }
        }
    }
}

