/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.JahiaVersionManagerImpl;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRLockUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.decorator.JCRVersion;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.query.QueryManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class JCRWorkspaceWrapper
implements Workspace {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceWrapper.class);
    private JCRSessionFactory service;
    private String name;
    private JCRSessionWrapper session;
    private JCRObservationManager observationManager;

    public JCRWorkspaceWrapper(String name, JCRSessionWrapper session, JCRSessionFactory service) {
        this.name = name;
        this.service = service;
        this.session = session;
    }

    public JCRSessionWrapper getSession() {
        return this.session;
    }

    public String getName() {
        return this.name;
    }

    public void copy(String source, String dest) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        final JCRStoreProvider provider = this.service.getProvider(source);
        JCRStoreProvider destProvider = this.service.getProvider(dest);
        if (destProvider != provider) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (provider.getMountPoint().length() > 1) {
            dest = dest.substring(provider.getMountPoint().length());
            source = source.substring(provider.getMountPoint().length());
        }
        final String fSource = source;
        final String fDest = dest;
        JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 3, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                session.getProviderSession(provider).getWorkspace().copy(fSource, fDest);
                return null;
            }
        });
    }

    public void copy(final String srcWs, String source, String dest) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        final JCRStoreProvider provider = this.service.getProvider(source);
        JCRStoreProvider destProvider = this.service.getProvider(dest);
        if (destProvider != provider) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (provider.getMountPoint().length() > 1) {
            dest = dest.substring(provider.getMountPoint().length());
            source = source.substring(provider.getMountPoint().length());
        }
        final String fSource = source;
        final String fDest = dest;
        JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 3, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                session.getProviderSession(provider).getWorkspace().copy(srcWs, fSource, fDest);
                return null;
            }
        });
        throw new UnsupportedRepositoryOperationException();
    }

    public void clone(final String srcWs, String source, String dest, final boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        final JCRStoreProvider provider = this.service.getProvider(source);
        JCRStoreProvider destProvider = this.service.getProvider(dest);
        if (destProvider != provider) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (provider.getMountPoint().length() > 1) {
            dest = dest.substring(provider.getMountPoint().length());
            source = source.substring(provider.getMountPoint().length());
        }
        final String fSource = source;
        final String fDest = dest;
        JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 4, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                session.getProviderSession(provider).getWorkspace().clone(srcWs, fSource, fDest, removeExisting);
                return null;
            }
        });
    }

    public void move(String source, String dest) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.move(source, dest, false);
    }

    void move(String source, String dest, final boolean sessionMove) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        block17: {
            final JCRStoreProvider provider = this.service.getProvider(source);
            JCRStoreProvider destProvider = this.service.getProvider(dest);
            if (destProvider != provider) {
                try {
                    this.session.getItem(dest);
                    throw new ItemExistsException(dest);
                }
                catch (RepositoryException repositoryException) {
                    if (sessionMove) {
                        this.getSession().getNode(source).copy(StringUtils.substringBeforeLast((String)dest, (String)"/"), StringUtils.substringAfterLast((String)dest, (String)"/"));
                        this.session.getItem(source).remove();
                        break block17;
                    }
                    throw new UnsupportedRepositoryOperationException();
                }
            }
            if (provider.getMountPoint().length() > 1) {
                dest = dest.substring(provider.getMountPoint().length());
                source = source.substring(provider.getMountPoint().length());
            }
            final String sourcePath = source;
            Node sourceNode = this.session.getProviderSession(provider).getNode(source);
            if (sourceNode.isNodeType("jmix:shareable")) {
                final String destination = dest;
                final JCRCallback<Object> callback = new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper sourceNode = session.getNode(sourcePath);
                        JCRNodeWrapper parentNode = session.getNode(StringUtils.substringBeforeLast((String)destination, (String)"/"));
                        String sourceParentPath = StringUtils.substringBeforeLast((String)sourcePath, (String)"/");
                        if (parentNode.getPath().equals(sourceParentPath)) {
                            JCRUserNode userFolder = session.getUserNode();
                            if (!userFolder.hasNode("tmp")) {
                                if (!userFolder.isCheckedOut()) {
                                    session.checkout(userFolder);
                                }
                                userFolder.addNode("tmp", "jnt:contentList");
                            }
                            JCRNodeWrapper newSourceNode = userFolder.getNode("tmp").clone(sourceNode, sourceNode.getIdentifier());
                            sourceNode.removeShare();
                            sourceNode = newSourceNode;
                        }
                        parentNode.clone(sourceNode, StringUtils.substringAfterLast((String)destination, (String)"/"));
                        ArrayList<Value> values = new ArrayList<Value>();
                        String v = sourcePath + ":::" + destination;
                        if (sourceNode.hasProperty("j:movedFrom")) {
                            values.addAll(Arrays.asList(sourceNode.getProperty("j:movedFrom").getValues()));
                            for (Value value : values) {
                                String s = value.getString();
                                if (!s.endsWith(":::" + sourcePath)) continue;
                                v = StringUtils.substringBefore((String)s, (String)":::") + ":::" + destination;
                                values.remove(value);
                                break;
                            }
                        }
                        values.add(JCRWorkspaceWrapper.this.getSession().getValueFactory().createValue(v));
                        sourceNode.setProperty("j:movedFrom", values.toArray(new Value[values.size()]));
                        sourceNode.removeShare();
                        if (parentNode.isNodeType("mix:lastModified")) {
                            parentNode.setProperty("jcr:lastModified", new GregorianCalendar());
                            parentNode.setProperty("jcr:lastModifiedBy", session.getUser().getName());
                        }
                        if (!sessionMove) {
                            session.save();
                        }
                        return null;
                    }
                };
                if (sessionMove) {
                    callback.doInJCR(this.session);
                } else {
                    JCRCallback<Object> jcrCallback = new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            return JCRObservationManager.doWorkspaceWriteCall(session, 2, callback);
                        }
                    };
                    if (this.session.isSystem()) {
                        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(this.session.getUser(), this.getName(), this.session.getLocale(), jcrCallback);
                    } else {
                        JCRTemplate.getInstance().doExecute(this.session.getUser(), this.getName(), this.session.getLocale(), jcrCallback);
                    }
                }
            } else {
                if (provider.isDefault()) {
                    JCRNodeWrapper parent = null;
                    JCRNodeWrapper jcrNode = this.session.getNode(source);
                    try {
                        parent = jcrNode.getParent();
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        // empty catch block
                    }
                    if (parent != null) {
                        JCRLockUtils.checkLock(parent, false, true);
                    }
                }
                if (sessionMove) {
                    this.session.getProviderSession(provider).move(source, dest);
                } else {
                    final String fSource = source;
                    final String fDest = dest;
                    JCRObservationManager.doWorkspaceWriteCall(this.getSession(), 2, new JCRCallback<Object>(){

                        @Override
                        public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                            session.getProviderSession(provider).getWorkspace().move(fSource, fDest);
                            return null;
                        }
                    });
                }
            }
        }
    }

    public void restore(Version[] versions, boolean b) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public QueryManagerWrapper getQueryManager() {
        return new QueryManagerImpl(this.session, this.service);
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.service.getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return NodeTypeRegistry.getInstance();
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.observationManager == null) {
            this.observationManager = new JCRObservationManager(this);
        }
        return this.observationManager;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        return this.getSession().getProviderSession(this.service.getProvider("/")).getWorkspace().getAccessibleWorkspaceNames();
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void importXML(String s, InputStream inputStream, int i) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public LockManagerWrapper getLockManager() {
        return new LockManagerWrapper();
    }

    public VersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new VersionManagerWrapper();
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    class LockManagerWrapper
    implements LockManager {
        LockManagerWrapper() {
        }

        public void addLockToken(String lockToken) {
            JCRWorkspaceWrapper.this.session.addLockToken(lockToken);
        }

        public Lock getLock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
            return JCRWorkspaceWrapper.this.session.getNode(absPath).getLock();
        }

        public String[] getLockTokens() throws RepositoryException {
            return JCRWorkspaceWrapper.this.session.getLockTokens();
        }

        public boolean holdsLock(String absPath) throws PathNotFoundException, RepositoryException {
            return JCRWorkspaceWrapper.this.session.getNode(absPath).holdsLock();
        }

        public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
            return JCRWorkspaceWrapper.this.session.getNode(absPath).lock(isDeep, isSessionScoped);
        }

        public boolean isLocked(String absPath) throws PathNotFoundException, RepositoryException {
            return JCRWorkspaceWrapper.this.session.getNode(absPath).isLocked();
        }

        public void removeLockToken(String lockToken) throws LockException, RepositoryException {
            JCRWorkspaceWrapper.this.session.removeLockToken(lockToken);
        }

        public void unlock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
            JCRWorkspaceWrapper.this.session.getNode(absPath).unlock();
        }
    }

    class VersionManagerWrapper
    implements VersionManager {
        VersionManagerWrapper() {
        }

        public JCRVersion checkin(final String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
            if (logger.isDebugEnabled()) {
                logger.debug("Checkin " + absPath + " in " + JCRWorkspaceWrapper.this.getName() + ", was " + this.getBaseVersion(absPath).getName());
            }
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 6, new JCRCallback<JCRVersion>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JCRVersion doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        JCRNodeWrapper node = session.getNode(absPath);
                        VersionManager versionManager = session.getProviderSession(node.getProvider()).getWorkspace().getVersionManager();
                        JCRVersion result = (JCRVersion)node.getProvider().getNodeWrapper((Node)versionManager.checkin(node.getRealNode().getPath()), session);
                        if (session.getLocale() != null) {
                            try {
                                versionManager.checkin(node.getI18N(session.getLocale()).getPath());
                            }
                            catch (ItemNotFoundException itemNotFoundException) {
                                // empty catch block
                            }
                        }
                        JCRVersion jCRVersion = result;
                        return jCRVersion;
                    }
                    finally {
                        if (logger.isDebugEnabled()) {
                            logger.debug(" now " + VersionManagerWrapper.this.getBaseVersion(absPath).getName());
                        }
                    }
                }
            });
        }

        public void checkout(final String absPath) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
            if (logger.isDebugEnabled()) {
                logger.debug("Checkout {} in {}", (Object)absPath, (Object)JCRWorkspaceWrapper.this.getName());
            }
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 7, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper node = session.getNode(absPath, false);
                    VersionManager versionManager = session.getProviderSession(node.getProvider()).getWorkspace().getVersionManager();
                    if (!node.getRealNode().isLocked() || session.isSystem()) {
                        versionManager.checkout(node.getRealNode().getPath());
                    }
                    if (session.getLocale() != null) {
                        try {
                            Node i18n = node.getI18N(session.getLocale());
                            if (!i18n.isLocked() || session.isSystem()) {
                                versionManager.checkout(i18n.getPath());
                            }
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }

        public Version checkpoint(final String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 8, new JCRCallback<Version>(){

                @Override
                public Version doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    return versionManager.checkpoint(absPath);
                }
            });
        }

        public boolean isCheckedOut(String absPath) throws RepositoryException {
            boolean result = true;
            JCRNodeWrapper node = JCRWorkspaceWrapper.this.getSession().getNode(absPath);
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(node.getProvider()).getWorkspace().getVersionManager();
            if (JCRWorkspaceWrapper.this.getSession().getLocale() != null) {
                try {
                    result = versionManager.isCheckedOut(node.getI18N(JCRWorkspaceWrapper.this.getSession().getLocale()).getPath());
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
            return result &= versionManager.isCheckedOut(absPath);
        }

        public VersionHistory getVersionHistory(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
            JCRStoreProvider provider = JCRWorkspaceWrapper.this.service.getProvider(absPath);
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(provider).getWorkspace().getVersionManager();
            return (VersionHistory)provider.getNodeWrapper((Node)versionManager.getVersionHistory(absPath), JCRWorkspaceWrapper.this.session);
        }

        public Version getBaseVersion(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
            return versionManager.getBaseVersion(absPath);
        }

        public void restore(final Version[] versions, final boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 9, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    HashMap<String, ArrayList<Version>> undecoratedVersionsByProvider = new HashMap<String, ArrayList<Version>>();
                    boolean i = false;
                    for (Version version : versions) {
                        JCRStoreProvider provider = JCRWorkspaceWrapper.this.service.getProvider(version.getPath());
                        ArrayList<Version> undecoratedVersionList = (ArrayList<Version>)undecoratedVersionsByProvider.get(provider.getKey());
                        if (undecoratedVersionList == null) {
                            undecoratedVersionList = new ArrayList<Version>();
                            undecoratedVersionsByProvider.put(provider.getKey(), undecoratedVersionList);
                        }
                        undecoratedVersionList.add(version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version);
                    }
                    for (Map.Entry entry : undecoratedVersionsByProvider.entrySet()) {
                        JCRStoreProvider provider = JCRWorkspaceWrapper.this.service.getProviders().get(entry.getKey());
                        VersionManager versionManager = session.getProviderSession(provider).getWorkspace().getVersionManager();
                        Version[] undecoratedVersions = ((List)entry.getValue()).toArray(new Version[((List)entry.getValue()).size()]);
                        versionManager.restore(undecoratedVersions, removeExisting);
                    }
                    return null;
                }
            });
            JCRWorkspaceWrapper.this.getSession().flushCaches();
        }

        public void restore(final String absPath, final String versionName, final boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 9, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    versionManager.restore(absPath, versionName, removeExisting);
                    return null;
                }
            });
            JCRWorkspaceWrapper.this.getSession().flushCaches();
        }

        public void restore(final Version version, final boolean removeExisting) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 9, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(version.getPath())).getWorkspace().getVersionManager();
                    versionManager.restore(version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version, removeExisting);
                    return null;
                }
            });
            JCRWorkspaceWrapper.this.getSession().flushCaches();
        }

        public void restore(final String absPath, final Version version, final boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 9, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    versionManager.restore(absPath, version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version, removeExisting);
                    return null;
                }
            });
            JCRWorkspaceWrapper.this.getSession().flushCaches();
        }

        public void restoreByLabel(final String absPath, final String versionLabel, final boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 9, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    versionManager.restoreByLabel(absPath, versionLabel, removeExisting);
                    return null;
                }
            });
            JCRWorkspaceWrapper.this.getSession().flushCaches();
        }

        public NodeIterator merge(final String absPath, final String srcWorkspace, final boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 11, new JCRCallback<NodeIterator>(){

                @Override
                public NodeIterator doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    return versionManager.merge(absPath, srcWorkspace, bestEffort);
                }
            });
        }

        public NodeIterator merge(final String absPath, final String srcWorkspace, final boolean bestEffort, final boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 11, new JCRCallback<NodeIterator>(){

                @Override
                public NodeIterator doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    return versionManager.merge(absPath, srcWorkspace, bestEffort, isShallow);
                }
            });
        }

        public void doneMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
            versionManager.doneMerge(absPath, version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version);
        }

        public void cancelMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
            versionManager.cancelMerge(absPath, version instanceof JCRVersion ? ((JCRVersion)version).getRealNode() : version);
        }

        public Node createConfiguration(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
            return versionManager.createConfiguration(absPath);
        }

        public Node setActivity(Node activity) throws UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(activity.getPath())).getWorkspace().getVersionManager();
            return versionManager.setActivity(activity);
        }

        public Node getActivity() throws UnsupportedRepositoryOperationException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.getSession().getProviderSession(JCRWorkspaceWrapper.this.service.getProvider("/")).getWorkspace().getVersionManager();
            return versionManager.getActivity();
        }

        public Node createActivity(final String title) throws UnsupportedRepositoryOperationException, RepositoryException {
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 5, new JCRCallback<Node>(){

                @Override
                public Node doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = JCRWorkspaceWrapper.this.getSession().getProviderSession(JCRWorkspaceWrapper.this.service.getProvider("/")).getWorkspace().getVersionManager();
                    return versionManager.createActivity(title);
                }
            });
        }

        public void removeActivity(Node node) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            VersionManager versionManager = JCRWorkspaceWrapper.this.session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(node.getPath())).getWorkspace().getVersionManager();
            versionManager.removeActivity(node);
        }

        public NodeIterator merge(final Node activityNode) throws VersionException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
            return JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 11, new JCRCallback<NodeIterator>(){

                @Override
                public NodeIterator doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(activityNode.getPath())).getWorkspace().getVersionManager();
                    return versionManager.merge(activityNode);
                }
            });
        }

        public void addPredecessor(final String absPath, final Version version) throws RepositoryException {
            JCRObservationManager.doWorkspaceWriteCall(JCRWorkspaceWrapper.this.getSession(), 11, new JCRCallback<NodeIterator>(){

                @Override
                public NodeIterator doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    VersionManager versionManager = session.getProviderSession(JCRWorkspaceWrapper.this.service.getProvider(absPath)).getWorkspace().getVersionManager();
                    if (versionManager instanceof JahiaVersionManagerImpl) {
                        ((JahiaVersionManagerImpl)versionManager).addPredecessor(absPath, version);
                    }
                    return null;
                }
            });
        }
    }
}

