/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.HashSet;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodenameListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(NodenameListener.class);

    @Override
    public int getEventTypes() {
        return 1;
    }

    public void onEvent(final EventIterator eventIterator) {
        try {
            JahiaUser user = ((JCREventIterator)eventIterator).getSession().getUser();
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(user, this.workspace, null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    HashSet<Session> sessions = new HashSet<Session>();
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        if (NodenameListener.this.isExternal(event)) continue;
                        String path = event.getPath();
                        if (event.getType() != 1) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Node has been added, we are updating its fullpath properties : " + path);
                        }
                        try {
                            JCRNodeWrapper item = (JCRNodeWrapper)session.getItem(path);
                            if (!NodenameListener.this.nodeAdded(item)) continue;
                            sessions.add(item.getRealNode().getSession());
                        }
                        catch (PathNotFoundException e) {
                            logger.debug("Node does not exist, continue");
                        }
                    }
                    for (Session jcrsession : sessions) {
                        jcrsession.save();
                    }
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private boolean nodeAdded(JCRNodeWrapper node) throws RepositoryException {
        boolean updated = false;
        if (!(!node.isNodeType("jmix:nodenameInfo") || node.hasProperty("j:nodename") && StringUtils.equals((String)node.getProperty("j:nodename").getString(), (String)node.getName()))) {
            try {
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                node.setProperty("j:nodename", node.getName());
                updated = true;
                if (logger.isDebugEnabled() && !node.isNew()) {
                    logger.debug("Node has been added, we are updating its name " + node.getName() + ")");
                }
            }
            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                // empty catch block
            }
        }
        return updated;
    }
}

