/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRNodeDecorator;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFrozenNode
extends JCRNodeDecorator {
    private static transient Logger logger = LoggerFactory.getLogger(JCRFrozenNode.class);
    private JCRSiteNode site;

    public JCRFrozenNode(JCRNodeWrapper node) {
        super(node);
    }

    @Override
    public String getUrl() {
        String frozenPrimaryType = this.getPropertyAsString("jcr:frozenPrimaryType");
        if (frozenPrimaryType.equals("jnt:file")) {
            try {
                return this.getProvider().getHttpPath() + "/" + this.getSession().getWorkspace().getName() + Text.escapePath((String)(this.getPropertyAsString("j:fullpath") + "?v=" + this.getParent().getName()));
            }
            catch (RepositoryException e) {
                logger.error("Error while retrieving fullpath property", (Throwable)e);
            }
        }
        return super.getUrl();
    }

    @Override
    public JCRSiteNode getResolveSite() throws RepositoryException {
        if (this.site != null) {
            return this.site;
        }
        try {
            String path = this.node.getProperty("j:fullpath").getValue().getString();
            if (path.startsWith("/sites/")) {
                this.site = new JCRSiteNode(this.getSession().getNode(path.substring(0, path.indexOf(47, 7))));
                return this.site;
            }
            if (path.startsWith("/modules/")) {
                this.site = new JCRSiteNode(this.getSession().getNode(path.substring(0, path.indexOf(47, 14))));
                return this.site;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

