/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.cluster.JahiaClusterNode;
import org.apache.jackrabbit.core.cluster.NodeLevelLockableJournal;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.DerbyConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;
import org.apache.jackrabbit.core.util.db.PostgreSQLConnectionHelper;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.jahia.services.content.impl.jackrabbit.DatabaseRecordIterator;
import org.jahia.services.content.impl.jackrabbit.RetryOnExceptionStrategy;
import org.jahia.services.content.impl.jackrabbit.RetryStrategyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JahiaJournal
extends AbstractJournal
implements DatabaseAware,
NodeLevelLockableJournal {
    private final Map<String, RecordConsumer> consumers = new HashMap<String, RecordConsumer>();
    private static final Logger log = LoggerFactory.getLogger(JahiaJournal.class);
    private String driver;
    private String url;
    private String databaseType = "default";
    private String user;
    private String password;
    private String dataSourceName;
    private ConnectionHelper conHelper;
    private int sleepTimeWaitingForLock = 500;
    private int numberOfRetries = 3;
    private boolean janitorEnabled = false;
    private int janitorSleep = 86400;
    private Calendar janitorNextRun;
    private Thread janitorThread;
    private DatabaseRevision databaseRevision;
    private String selectRevisionsStmtSQL;
    private String updateGlobalStmtSQL;
    private String selectGlobalStmtSQL;
    private String insertRevisionStmtSQL;
    private String selectMinLocalRevisionStmtSQL;
    private String cleanRevisionStmtSQL;
    private String getLocalRevisionStmtSQL;
    private String insertLocalRevisionStmtSQL;
    private String updateLocalRevisionStmtSQL;
    private String insertLockSQL;
    private String deleteLockSQL;
    private String schemaObjectPrefix = "";
    private ConnectionFactory connectionFactory;

    public JahiaJournal() {
        this.setJanitorFirstRunHourOfDay(3);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        this.initDatabaseType();
        try {
            this.conHelper = this.createConnectionHelper(this.getDataSource());
            this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
            this.buildSQLStatements();
            this.initInstanceRevisionAndJanitor();
        }
        catch (Exception e) {
            throw new JournalException("Error when initalizing the journal", (Throwable)e);
        }
        log.info("JahiaJournal initialized.");
    }

    protected void initDatabaseType() throws JournalException {
        if (this.driver == null && this.dataSourceName == null) {
            throw new JournalException("Driver not specified.");
        }
        if (this.url == null && this.dataSourceName == null) {
            throw new JournalException("Connection URL not specified.");
        }
        if (this.dataSourceName != null) {
            try {
                String configuredDatabaseType = this.connectionFactory.getDataBaseType(this.dataSourceName);
                try (InputStream resourceStream = DatabaseJournal.class.getResourceAsStream(configuredDatabaseType + ".ddl");){
                    if (resourceStream != null) {
                        this.setDatabaseType(configuredDatabaseType);
                    }
                }
                catch (IOException e) {
                    log.warn("Ignored exception on resource close", (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                throw new JournalException("failed to get database type", (Throwable)e);
            }
        }
        if (this.databaseType == null) {
            try {
                this.databaseType = JahiaJournal.getDatabaseTypeFromURL(this.url);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to derive database type from URL: " + e.getMessage();
                throw new JournalException(msg);
            }
        }
    }

    private DataSource getDataSource() throws RepositoryException, SQLException {
        if (StringUtils.isEmpty((String)this.dataSourceName)) {
            return this.connectionFactory.getDataSource(this.driver, this.url, this.user, this.password);
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        Object helper = null;
        if ("oracle".equalsIgnoreCase(this.databaseType)) {
            helper = new OracleConnectionHelper(dataSrc, false);
            helper.init();
        } else {
            helper = "postgresql".equalsIgnoreCase(this.databaseType) ? new PostgreSQLConnectionHelper(dataSrc, false) : ("derby".equalsIgnoreCase(this.databaseType) ? new DerbyConnectionHelper(dataSrc, false) : new ConnectionHelper(dataSrc, false));
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInstanceRevisionAndJanitor() throws JournalException {
        long localFileRevision = 0L;
        if (this.getRevision() != null) {
            try (FileRevision currentFileRevision = new FileRevision(new File(this.getRevision()), true);){
                localFileRevision = currentFileRevision.get();
            }
        }
        this.databaseRevision = new DatabaseRevision(localFileRevision);
        long localRevision = this.databaseRevision.get();
        log.info("Initialized local revision to {}", (Object)localRevision);
        if (this.janitorEnabled) {
            this.janitorThread = new Thread((Runnable)new RevisionTableJanitor(), "Jackrabbit-ClusterRevisionJanitor");
            this.janitorThread.setDaemon(true);
            this.janitorThread.start();
            log.info("Cluster revision janitor thread started; first run scheduled at {}", (Object)this.janitorNextRun.getTime());
        } else {
            log.info("Cluster revision janitor thread not started");
        }
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.databaseRevision;
    }

    private static String getDatabaseTypeFromURL(String url) {
        int end;
        int start = url.indexOf(58);
        if (start != -1 && (end = url.indexOf(58, start + 1)) != -1) {
            return url.substring(start + 1, end);
        }
        throw new IllegalArgumentException(url);
    }

    public RecordIterator getRecords(long startRevision) throws JournalException {
        try {
            return new DatabaseRecordIterator(this.conHelper.exec(this.selectRevisionsStmtSQL, new Object[]{startRevision}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            throw new JournalException("Unable to return record iterator.", (Throwable)e);
        }
    }

    public RecordIterator getRecords() throws JournalException {
        return this.getRecords(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long startRevision, boolean startup) throws JournalException {
        if (!startup) {
            this.doSync(startRevision);
        } else {
            this.startBatch();
            boolean success = false;
            try {
                this.doSync(startRevision);
                success = true;
            }
            finally {
                this.endBatch(success);
            }
        }
    }

    protected void doLock() throws JournalException {
    }

    protected void doUnlock(boolean successful) {
    }

    @Override
    public void lockNodes(Set<NodeId> ids) throws JournalException {
        RetryOnExceptionStrategy retryStrategy = new RetryOnExceptionStrategy(this.numberOfRetries, this.sleepTimeWaitingForLock);
        while (retryStrategy.canRetry()) {
            try {
                this.internalLockNodes(ids);
                return;
            }
            catch (SQLIntegrityConstraintViolationException e) {
                log.debug("Cannot lock {} . Reason: {}", (Object)StringUtils.join(ids, (String)","), (Object)e.getMessage());
                try {
                    retryStrategy.onErrorOccured();
                }
                catch (RetryStrategyException rsex) {
                    throw new JournalException(rsex.getMessage(), (Throwable)rsex);
                }
                this.sync(false);
            }
        }
    }

    private void internalLockNodes(Set<NodeId> ids) throws JournalException, SQLIntegrityConstraintViolationException {
        ids = new TreeSet<NodeId>(ids);
        boolean success = false;
        this.startBatch();
        try {
            for (NodeId id : ids) {
                log.debug("Lock {}", (Object)id);
                this.conHelper.exec(this.insertLockSQL, new Object[]{id.toString(), this.getId()});
            }
            success = true;
        }
        catch (SQLIntegrityConstraintViolationException sicvEx) {
            throw sicvEx;
        }
        catch (SQLException e) {
            throw new JournalException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.endBatch(success);
        }
    }

    @Override
    public void unlockNodes(Set<NodeId> ids) throws JournalException {
        try {
            for (NodeId id : ids) {
                log.debug("Unlock {}", (Object)id);
                this.conHelper.exec(this.deleteLockSQL, new Object[]{id.toString()}, false, 0);
            }
        }
        catch (SQLException e) {
            throw new JournalException("Unable to unlock nodes.", (Throwable)e);
        }
    }

    private void startBatch() throws JournalException {
        try {
            this.conHelper.startBatch();
        }
        catch (SQLException e) {
            throw new JournalException("Unable to start batch and set autocommit to false.", (Throwable)e);
        }
    }

    private void endBatch(boolean successful) throws JournalException {
        try {
            this.conHelper.endBatch(successful);
        }
        catch (SQLException e) {
            throw new JournalException("failed to end batch", (Throwable)e);
        }
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        ResultSet rs = null;
        boolean succeeded = false;
        this.startBatch();
        try {
            this.conHelper.exec(this.updateGlobalStmtSQL, new Object[0]);
            rs = this.conHelper.exec(this.selectGlobalStmtSQL, null, false, 0);
            if (!rs.next()) {
                throw new JournalException("No revision available.");
            }
            long lockedRevision = rs.getLong(1);
            record.setRevision(lockedRevision);
            this.conHelper.exec(this.insertRevisionStmtSQL, new Object[]{lockedRevision, this.getId(), record.getProducerId(), new StreamWrapper(in, (long)length)});
            succeeded = true;
        }
        catch (SQLException e) {
            try {
                throw new JournalException("Unable to lock global revision table.", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.endBatch(succeeded);
                DbUtility.close(rs);
                throw throwable;
            }
        }
        this.endBatch(succeeded);
        DbUtility.close((ResultSet)rs);
    }

    public void close() {
        if (this.janitorThread != null) {
            this.janitorThread.interrupt();
        }
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID > ? order by REVISION_ID";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION set REVISION_ID = REVISION_ID + 1";
        this.selectGlobalStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "JOURNAL (REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) values (?,?,?,?)";
        this.selectMinLocalRevisionStmtSQL = "select MIN(REVISION_ID) from " + this.schemaObjectPrefix + "LOCAL_REVISIONS";
        this.cleanRevisionStmtSQL = "delete from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID < ?";
        this.getLocalRevisionStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "LOCAL_REVISIONS where JOURNAL_ID = ?";
        this.insertLocalRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "LOCAL_REVISIONS (REVISION_ID, JOURNAL_ID) values (?,?)";
        this.updateLocalRevisionStmtSQL = "update " + this.schemaObjectPrefix + "LOCAL_REVISIONS set REVISION_ID = ? where JOURNAL_ID = ?";
        this.insertLockSQL = "insert into " + this.schemaObjectPrefix + "LOCKS (NODE_ID, JOURNAL_ID) values (?,?)";
        this.deleteLockSQL = "delete from " + this.schemaObjectPrefix + "LOCKS where NODE_ID = ?";
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Deprecated
    public void setSchema(String databaseType) {
        this.setDatabaseType(databaseType);
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJanitorEnabled(boolean enabled) {
        this.janitorEnabled = enabled;
    }

    public void setJanitorSleep(int sleep) {
        this.janitorSleep = sleep;
    }

    public void setJanitorFirstRunHourOfDay(int hourOfDay) {
        this.janitorNextRun = Calendar.getInstance();
        if (this.janitorNextRun.get(11) >= hourOfDay) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, hourOfDay);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Deprecated
    public final void setSchemaCheckEnabled(boolean enabled) {
    }

    public void setSleepTimeWaitingForLock(int sleepTimeWaitingForLock) {
        this.sleepTimeWaitingForLock = sleepTimeWaitingForLock;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync(long startRevision) throws JournalException {
        log.debug("Getting revisions from {}", (Object)startRevision);
        long stopRevision = Long.MIN_VALUE;
        try (RecordIterator iterator = this.getRecords(startRevision);){
            while (iterator.hasNext()) {
                Record record = iterator.nextRecord();
                if (record.getJournalId().equals(this.getId())) {
                    log.debug("Record with revision '" + record.getRevision() + "' created by this journal, skipped.");
                } else {
                    RecordConsumer consumer = this.getConsumer(record.getProducerId());
                    if (consumer != null) {
                        consumer.consume(record);
                    }
                }
                stopRevision = record.getRevision();
            }
        }
        if (stopRevision > 0L) {
            for (RecordConsumer consumer : this.consumers.values()) {
                if (consumer instanceof JahiaClusterNode) {
                    ((JahiaClusterNode)consumer).reallySetRevision(stopRevision);
                    continue;
                }
                consumer.setRevision(stopRevision);
            }
            log.debug("Synchronized from revision {} to revision: {}", (Object)startRevision, (Object)stopRevision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RecordConsumer consumer) throws JournalException {
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            if (this.consumers.containsKey(consumerId)) {
                String msg = "Record consumer with identifier '" + consumerId + "' already registered.";
                throw new JournalException(msg);
            }
            this.consumers.put(consumerId, consumer);
        }
        super.register(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(RecordConsumer consumer) {
        Map<String, RecordConsumer> map = this.consumers;
        synchronized (map) {
            String consumerId = consumer.getId();
            this.consumers.remove(consumerId);
        }
        return super.unregister(consumer);
    }

    private class RevisionTableJanitor
    implements Runnable {
        private RevisionTableJanitor() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    log.info("Next clean-up run scheduled at {}", (Object)JahiaJournal.this.janitorNextRun.getTime());
                    long sleepTime = JahiaJournal.this.janitorNextRun.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    this.cleanUpOldRevisions();
                    JahiaJournal.this.janitorNextRun.add(13, JahiaJournal.this.janitorSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.info("Interrupted: stopping clean-up task.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanUpOldRevisions() {
            ResultSet rs = null;
            try {
                long minRevision = 0L;
                rs = JahiaJournal.this.conHelper.exec(JahiaJournal.this.selectMinLocalRevisionStmtSQL, null, false, 0);
                boolean cleanUp = rs.next();
                if (cleanUp) {
                    minRevision = rs.getLong(1);
                }
                if (cleanUp) {
                    JahiaJournal.this.conHelper.exec(JahiaJournal.this.cleanRevisionStmtSQL, new Object[]{minRevision});
                    log.info("Cleaned old revisions up to revision {}.", (Object)minRevision);
                }
                DbUtility.close((ResultSet)rs);
            }
            catch (Exception e) {
                log.warn("Failed to clean up old revisions.", (Throwable)e);
            }
            finally {
                DbUtility.close(rs);
            }
        }
    }

    private class DatabaseRevision
    implements InstanceRevision {
        private long localRevision;

        public DatabaseRevision(long revision) throws JournalException {
            ResultSet rs = null;
            try {
                rs = JahiaJournal.this.conHelper.exec(JahiaJournal.this.getLocalRevisionStmtSQL, new Object[]{JahiaJournal.this.getId()}, false, 0);
                boolean exists = rs.next();
                boolean needUpdate = false;
                if (exists) {
                    long dbRevision = rs.getLong(1);
                    if (dbRevision < revision) {
                        needUpdate = true;
                    } else {
                        revision = dbRevision;
                    }
                }
                if (!exists) {
                    JahiaJournal.this.conHelper.exec(JahiaJournal.this.insertLocalRevisionStmtSQL, new Object[]{revision, JahiaJournal.this.getId()});
                } else if (needUpdate) {
                    JahiaJournal.this.conHelper.exec(JahiaJournal.this.updateLocalRevisionStmtSQL, new Object[]{revision, JahiaJournal.this.getId()});
                }
                this.localRevision = revision;
            }
            catch (SQLException e) {
                try {
                    throw new JournalException("Failed to initialize local revision", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close((ResultSet)rs);
        }

        public synchronized long get() {
            return this.localRevision;
        }

        public synchronized void set(long localRevision) throws JournalException {
            try {
                JahiaJournal.this.conHelper.exec(JahiaJournal.this.updateLocalRevisionStmtSQL, new Object[]{localRevision, JahiaJournal.this.getId()});
                this.localRevision = localRevision;
            }
            catch (SQLException e) {
                throw new JournalException("Failed to update local revision.", (Throwable)e);
            }
        }

        public void close() {
        }
    }
}

