/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.interceptor.PropertyInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

public class InterceptorChain {
    private List<PropertyInterceptor> interceptors = new ArrayList<PropertyInterceptor>();
    private List<PropertyInterceptor> revInterceptors;

    public void setInterceptors(List<PropertyInterceptor> interceptors) {
        this.interceptors = interceptors;
        this.revInterceptors = new ArrayList<PropertyInterceptor>(interceptors);
        Collections.reverse(this.revInterceptors);
    }

    public void beforeRemove(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        for (PropertyInterceptor interceptor : this.interceptors) {
            if (!interceptor.canApplyOnProperty(node, definition)) continue;
            interceptor.beforeRemove(node, name, definition);
        }
    }

    public Value beforeSetValue(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        for (PropertyInterceptor interceptor : this.interceptors) {
            if (!interceptor.canApplyOnProperty(node, definition)) continue;
            originalValue = interceptor.beforeSetValue(node, name, definition, originalValue);
        }
        return originalValue;
    }

    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        for (PropertyInterceptor interceptor : this.interceptors) {
            if (!interceptor.canApplyOnProperty(node, definition)) continue;
            originalValues = interceptor.beforeSetValues(node, name, definition, originalValues);
        }
        return originalValues;
    }

    public Value afterGetValue(JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        for (PropertyInterceptor interceptor : this.revInterceptors) {
            if (!interceptor.canApplyOnProperty(property.getParent(), (ExtendedPropertyDefinition)property.getDefinition())) continue;
            storedValue = interceptor.afterGetValue(property, storedValue);
        }
        return storedValue;
    }

    public Value[] afterGetValues(JCRPropertyWrapper property, Value[] storedValues) throws ValueFormatException, RepositoryException {
        for (PropertyInterceptor interceptor : this.revInterceptors) {
            if (!interceptor.canApplyOnProperty(property.getParent(), (ExtendedPropertyDefinition)property.getDefinition())) continue;
            storedValues = interceptor.afterGetValues(property, storedValues);
        }
        return storedValues;
    }
}

