/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.Locale;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

public class LastModifiedInterceptor
extends BaseInterceptor {
    @Override
    public boolean canApplyOnProperty(JCRNodeWrapper node, ExtendedPropertyDefinition definition) throws RepositoryException {
        return node.getSession().getLocale() != null && definition.getDeclaringNodeType().getName().equals("mix:lastModified");
    }

    @Override
    public Value afterGetValue(JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        try {
            JCRNodeWrapper parent = property.getParent();
            Locale locale = property.getSession().getLocale();
            if (!parent.hasI18N(locale)) {
                return storedValue;
            }
            Node i18n = parent.getI18N(locale);
            if (i18n.hasProperty("jcr:lastModified")) {
                boolean isLM = property.getName().equals("jcr:lastModified");
                Value lastModified = isLM ? storedValue : property.getParent().getRealNode().getProperty("jcr:lastModified").getValue();
                Value i18nLastModified = i18n.getProperty("jcr:lastModified").getValue();
                if (i18nLastModified.getDate().after(lastModified.getDate())) {
                    return isLM ? i18nLastModified : i18n.getProperty(property.getName()).getValue();
                }
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return storedValue;
    }
}

