/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor.url;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PropertyConstraintViolationException;
import org.jahia.services.content.interceptor.URLInterceptor;
import org.jahia.services.content.interceptor.url.URLReplacer;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.JahiaLocaleContextHolder;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseURLReplacer
implements URLReplacer {
    private static Logger logger = LoggerFactory.getLogger(BaseURLReplacer.class);
    private URLInterceptor urlInterceptor;

    @Override
    public boolean canHandle(String tagName, String attrName) {
        return true;
    }

    @Override
    public String replaceRefsByPlaceholders(final String originalValue, final Map<String, Long> newRefs, final Map<String, Long> oldRefs, String workspace, final Locale locale, final JCRNodeWrapper node, final ExtendedPropertyDefinition definition) throws RepositoryException {
        boolean isCmsContext;
        String pathPart;
        if (logger.isDebugEnabled()) {
            logger.debug("Before replaceRefsByPlaceholders : " + originalValue);
        }
        if ((pathPart = originalValue).startsWith(this.urlInterceptor.getDmsContext())) {
            pathPart = StringUtils.substringAfter((String)StringUtils.substringAfter((String)pathPart, (String)this.urlInterceptor.getDmsContext()), (String)"/");
            isCmsContext = false;
        } else if (pathPart.startsWith(this.urlInterceptor.getCmsContext())) {
            Matcher m = this.urlInterceptor.getCmsPattern().matcher(pathPart);
            if (!m.matches()) {
                throw new PropertyConstraintViolationException(node, Messages.getInternal("label.error.invalidlink", JahiaLocaleContextHolder.getLocale(), "Invalid link") + pathPart, definition.isInternationalized() ? locale : null, definition);
            }
            pathPart = m.group(5);
            isCmsContext = true;
        } else {
            return originalValue;
        }
        String pathTmp = StringUtils.substringBeforeLast((String)("/" + WebUtils.urlDecode(pathPart)), (String)"?");
        final String path = pathTmp = StringUtils.substringBeforeLast((String)pathTmp, (String)"#");
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper reference;
                String value = originalValue;
                String ext = null;
                String tpl = null;
                try {
                    String currentPath = path;
                    if (isCmsContext) {
                        while (true) {
                            int i;
                            if ((i = currentPath.lastIndexOf(46)) > currentPath.lastIndexOf(47)) {
                                if (ext == null) {
                                    ext = currentPath.substring(i + 1);
                                } else {
                                    tpl = tpl == null ? currentPath.substring(i + 1) : currentPath.substring(i + 1) + "." + tpl;
                                }
                            } else {
                                throw new PathNotFoundException("not found in " + path);
                            }
                            currentPath = currentPath.substring(0, i);
                            try {
                                reference = session.getNode(JCRContentUtils.escapeNodePath(currentPath));
                            }
                            catch (PathNotFoundException pathNotFoundException) {
                                continue;
                            }
                            break;
                        }
                        value = "##cms-context##/" + StringUtils.substringAfter((String)value, (String)BaseURLReplacer.this.urlInterceptor.getCmsContext());
                    } else {
                        while (true) {
                            if (!StringUtils.contains((String)currentPath, (char)'/')) {
                                throw new PathNotFoundException("not found in " + path);
                            }
                            currentPath = StringUtils.substringAfter((String)currentPath, (String)"/");
                            try {
                                reference = session.getNode(JCRContentUtils.escapeNodePath("/" + currentPath));
                            }
                            catch (PathNotFoundException i) {
                                continue;
                            }
                            break;
                        }
                        value = "##doc-context##/" + StringUtils.substringAfter((String)value, (String)BaseURLReplacer.this.urlInterceptor.getDmsContext());
                    }
                }
                catch (PathNotFoundException e) {
                    throw new PropertyConstraintViolationException(node, Messages.getInternal("label.error.invalidlink", JahiaLocaleContextHolder.getLocale(), "Invalid link") + path, definition.isInternationalized() ? locale : null, definition);
                }
                String id = reference.getIdentifier();
                if (!newRefs.containsKey(id)) {
                    if (oldRefs.containsKey(id)) {
                        newRefs.put(id, oldRefs.get(id));
                    } else {
                        Long max = Math.max(oldRefs.isEmpty() ? 0L : (Long)Collections.max(oldRefs.values()), newRefs.isEmpty() ? 0L : (Long)Collections.max(newRefs.values()));
                        newRefs.put(id, max + 1L);
                    }
                }
                Long index = (Long)newRefs.get(id);
                String link = "/##ref:link" + index + "##";
                if (tpl != null) {
                    link = link + "." + tpl;
                }
                if (ext != null) {
                    link = link + "." + ext;
                }
                value = WebUtils.urlDecode(value).replace(path, link);
                if (logger.isDebugEnabled()) {
                    logger.debug("After replaceRefsByPlaceholders : " + value);
                }
                return value;
            }
        });
    }

    @Override
    public String replacePlaceholdersByRefs(final String originalValue, final Map<Long, String> refs, String workspaceName, Locale locale, final JCRNodeWrapper parent) throws RepositoryException {
        boolean isCmsContext;
        String pathPart = originalValue;
        if (logger.isDebugEnabled()) {
            logger.debug("Before replacePlaceholdersByRefs : " + originalValue);
        }
        if (pathPart.startsWith("##doc-context##/")) {
            pathPart = StringUtils.substringAfter((String)StringUtils.substringAfter((String)pathPart, (String)"##doc-context##/"), (String)"/");
            isCmsContext = false;
        } else if (pathPart.startsWith("##cms-context##/")) {
            Matcher m = this.urlInterceptor.getCmsPatternWithContextPlaceholder().matcher(pathPart);
            if (!m.matches()) {
                logger.error("Cannot match URL : " + pathPart);
                return originalValue;
            }
            pathPart = m.group(5);
            isCmsContext = true;
        } else {
            return originalValue;
        }
        final String path = "/" + pathPart;
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspaceName, null, new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String value = originalValue;
                try {
                    Matcher matcher = BaseURLReplacer.this.urlInterceptor.getRefPattern().matcher(path);
                    if (!matcher.matches()) {
                        logger.error("Cannot match value, should contain ##ref : " + path);
                        return originalValue;
                    }
                    String id = matcher.group(1);
                    String ext = matcher.group(2);
                    String uuid = (String)refs.get(new Long(id));
                    String nodePath = null;
                    JCRNodeWrapper node = null;
                    if (!StringUtils.isEmpty((String)uuid)) {
                        try {
                            node = session.getNodeByUUID(uuid);
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (node == null) {
                        logger.warn("Cannot find referenced item : " + parent.getPath() + " -> " + path + " -> " + uuid);
                        return "#";
                    }
                    nodePath = Text.escapePath((String)node.getPath());
                    value = originalValue.replace(path, nodePath + ext);
                    value = isCmsContext ? URLInterceptor.CMS_CONTEXT_PLACEHOLDER_PATTERN.matcher(value).replaceAll(BaseURLReplacer.this.urlInterceptor.getCmsContext()) : URLInterceptor.DOC_CONTEXT_PLACEHOLDER_PATTERN.matcher(value).replaceAll(BaseURLReplacer.this.urlInterceptor.getDmsContext());
                    if (logger.isDebugEnabled()) {
                        logger.debug("After replacePlaceholdersByRefs : " + value);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception when transforming placeholder for " + parent.getPath() + " -> " + path, (Throwable)e);
                }
                return value;
            }
        });
    }

    public URLInterceptor getUrlInterceptor() {
        return this.urlInterceptor;
    }

    public void setUrlInterceptor(URLInterceptor urlInterceptor) {
        this.urlInterceptor = urlInterceptor;
    }
}

