/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.JahiaCndReader;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;

public class JahiaGroupingFileReader
extends JahiaCndReader {
    public JahiaGroupingFileReader(Reader r, String filename, String systemId, NodeTypeRegistry registry) throws ParseException {
        super(r, filename, systemId, registry);
    }

    @Override
    public void parse() throws ParseException {
        this.nextToken();
        while (!this.currentTokenEquals("eof")) {
            this.parseNodeType();
        }
    }

    private void parseNodeType() throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Missing '[' delimiter for beginning of node type name");
        }
        this.nextToken();
        ExtendedNodeType nt = null;
        try {
            nt = this.registry.getNodeType(this.currentToken);
        }
        catch (NoSuchNodeTypeException e) {
            this.lexer.fail("No such node type", e);
        }
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
        ArrayList<String> groups = new ArrayList<String>();
        this.parseGroup(nt, groups);
        nt.setGroupedItems(groups);
    }

    private void parseGroup(ExtendedNodeType nt, List groups) throws ParseException {
        while (true) {
            if (this.currentTokenEquals('-') || this.currentTokenEquals('+')) {
                String t = this.currentToken;
                this.nextToken();
                groups.add(t + this.currentToken);
            } else if (this.currentTokenEquals('(')) {
                ArrayList subGroup = new ArrayList();
                this.nextToken();
                this.parseGroup(nt, subGroup);
                if (this.currentTokenEquals(')')) {
                    groups.add(subGroup);
                } else {
                    this.lexer.fail("Missing ')', found " + this.currentToken);
                }
            } else {
                this.lexer.fail("Unexpected token " + this.currentToken);
            }
            this.nextToken();
            if (!this.currentTokenEquals(',')) break;
            this.nextToken();
        }
    }
}

