/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.initializers.TemplatesChoiceListInitializerImpl;
import org.jahia.services.content.nodetypes.renderer.AbstractChoiceListRenderer;
import org.jahia.services.render.RenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortableFieldnamesChoiceListInitializerImpl
extends AbstractChoiceListRenderer
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(TemplatesChoiceListInitializerImpl.class);
    private Set<String> excludedNodeTypes = Collections.emptySet();
    private boolean showHidden;
    private boolean showProtected = true;

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition declaringPropertyDefinition, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ExtendedPropertyDefinition[] propertyDefs;
        if (context == null) {
            return Collections.emptyList();
        }
        JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
        ExtendedNodeType realNodeType = (ExtendedNodeType)context.get("contextType");
        CommonDefinitions commonChildNodeDefinitions = null;
        try {
            if (node == null && realNodeType == null) {
                return Collections.emptyList();
            }
            if (node != null && node.hasNodes()) {
                commonChildNodeDefinitions = SortableFieldnamesChoiceListInitializerImpl.getCommonChildNodeDefinitions(node, this.showHidden, this.showProtected, this.excludedNodeTypes);
                propertyDefs = commonChildNodeDefinitions.getPropertyDefinitions();
            } else {
                propertyDefs = realNodeType.getPropertyDefinitions();
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        LinkedList<ChoiceListValue> vs = new LinkedList<ChoiceListValue>();
        for (ExtendedPropertyDefinition propertyDef : propertyDefs) {
            vs.add(new ChoiceListValue(propertyDef.getLabel(locale), null, new ValueImpl(propertyDef.getName(), 1, false)));
        }
        if (commonChildNodeDefinitions != null && commonChildNodeDefinitions.getReferencedDefs() != null && commonChildNodeDefinitions.getReferencedDefs().size() > 0) {
            Map<String, Map<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>>> referencedDefs = commonChildNodeDefinitions.getReferencedDefs();
            for (Map.Entry<String, Map<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>>> entry : referencedDefs.entrySet()) {
                for (Map.Entry<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>> s : entry.getValue().entrySet()) {
                    for (ExtendedPropertyDefinition propertyDefinition : s.getValue().values()) {
                        vs.add(new ChoiceListValue(s.getKey().getLabel(locale) + "->" + propertyDefinition.getLabel(locale), null, new ValueImpl(s.getKey().getName() + ";" + propertyDefinition.getName(), 1, false)));
                    }
                }
            }
        }
        Collections.sort(vs);
        return vs;
    }

    public static CommonDefinitions getCommonChildNodeDefinitions(JCRNodeWrapper node, boolean showHidden, boolean showProtected, Set<String> excludedNodeTypes) throws RepositoryException {
        Map defs = null;
        Map referencedDefs = null;
        if (node.hasNodes()) {
            JCRNodeIteratorWrapper children = node.getNodes();
            while (children.hasNext()) {
                JCRNodeWrapper child = (JCRNodeWrapper)children.nextNode();
                if (!excludedNodeTypes.isEmpty() && excludedNodeTypes.contains(child.getPrimaryNodeType().getName())) continue;
                if (defs == null) {
                    defs = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

                        public Object create() {
                            return new HashMap();
                        }
                    });
                    referencedDefs = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

                        public Object create() {
                            return LazyMap.decorate(new HashMap(), (Factory)new Factory(){

                                public Object create() {
                                    return new HashMap();
                                }
                            });
                        }
                    });
                    for (ExtendedPropertyDefinition propertyDef : child.getPrimaryNodeType().getPropertyDefinitions()) {
                        ExtendedNodeType nodeType;
                        if (!showHidden && propertyDef.isHidden() || !showProtected && propertyDef.isProtected()) continue;
                        if (propertyDef.getRequiredType() == 10 || propertyDef.getRequiredType() == 9) {
                            String[] constraints;
                            nodeType = propertyDef.getDeclaringNodeType();
                            if (!excludedNodeTypes.isEmpty() && excludedNodeTypes.contains(nodeType.getName())) continue;
                            for (String constraint : constraints = propertyDef.getValueConstraints()) {
                                ExtendedPropertyDefinition[] declaredPropertyDefinitions;
                                ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(constraint);
                                for (ExtendedPropertyDefinition declaredPropertyDefinition : declaredPropertyDefinitions = extendedNodeType.getPropertyDefinitions()) {
                                    if (!showHidden && declaredPropertyDefinition.isHidden() || !showProtected && declaredPropertyDefinition.isProtected()) continue;
                                    ((Map)((Map)referencedDefs.get(nodeType.getName())).get(propertyDef)).put(declaredPropertyDefinition.getName(), declaredPropertyDefinition);
                                }
                            }
                            continue;
                        }
                        nodeType = propertyDef.getDeclaringNodeType();
                        if (!excludedNodeTypes.isEmpty() && excludedNodeTypes.contains(nodeType.getName())) continue;
                        ((Map)defs.get(nodeType.getName())).put(propertyDef.getName(), propertyDef);
                    }
                } else {
                    Iterator iterator = defs.keySet().iterator();
                    while (iterator.hasNext()) {
                        String commonType = (String)iterator.next();
                        if (child.isNodeType(commonType)) continue;
                        iterator.remove();
                        referencedDefs.remove(commonType);
                    }
                }
                if (!defs.isEmpty()) continue;
                break;
            }
            LinkedList propertyDefinitions = new LinkedList();
            if (defs != null) {
                for (Map props : defs.values()) {
                    propertyDefinitions.addAll(props.values());
                }
            }
            return new CommonDefinitions(propertyDefinitions.toArray(new ExtendedPropertyDefinition[propertyDefinitions.size()]), referencedDefs);
        }
        return new CommonDefinitions(new ExtendedPropertyDefinition[0], null);
    }

    @Override
    public String getStringRendering(RenderContext context, JCRPropertyWrapper propertyWrapper) throws RepositoryException {
        return JCRContentUtils.getDisplayLabel(propertyWrapper, context.getMainResource().getLocale(), propertyWrapper.getParent().getPrimaryNodeType());
    }

    @Override
    public String getStringRendering(Locale locale, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        return JCRContentUtils.getDisplayLabel(propertyValue, locale, propDef.getDeclaringNodeType());
    }

    public void setExcludedNodeTypes(Set<String> excludedNodeTypes) {
        this.excludedNodeTypes = excludedNodeTypes;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setShowProtected(boolean showProtected) {
        this.showProtected = showProtected;
    }

    public static class CommonDefinitions {
        ExtendedPropertyDefinition[] propertyDefinitions = null;
        Map<String, Map<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>>> referencedDefs = null;

        public CommonDefinitions(ExtendedPropertyDefinition[] propertyDefinitions, Map<String, Map<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>>> referencedDefs) {
            this.propertyDefinitions = propertyDefinitions;
            this.referencedDefs = referencedDefs;
        }

        public ExtendedPropertyDefinition[] getPropertyDefinitions() {
            return this.propertyDefinitions;
        }

        public Map<String, Map<ExtendedPropertyDefinition, Map<String, ExtendedPropertyDefinition>>> getReferencedDefs() {
            return this.referencedDefs;
        }
    }
}

