/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRFileNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderService;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatesNodeChoiceListInitializer
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(TemplatesNodeChoiceListInitializer.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> vs = new ArrayList<ChoiceListValue>();
        ArrayList<ChoiceListValue> tmpVs = new ArrayList<ChoiceListValue>();
        try {
            ExtendedNodeType nodetype;
            JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
            if (node == null) {
                node = (JCRNodeWrapper)context.get("contextParent");
                nodetype = (ExtendedNodeType)context.get("contextType");
            } else {
                nodetype = node.getPrimaryNodeType();
            }
            JCRSiteNode site = node.getResolveSite();
            JCRSessionWrapper session = site.getSession();
            String templateType = "contentTemplate";
            if (StringUtils.isEmpty((String)param)) {
                if (nodetype.isNodeType("jnt:page")) {
                    templateType = "pageTemplate";
                }
            } else {
                templateType = param;
            }
            Set<String> installedModules = site.getInstalledModulesWithAllDependencies();
            String defaultTemplate = null;
            try {
                defaultTemplate = site.hasProperty("j:defaultTemplateName") ? site.getProperty("j:defaultTemplateName").getString() : null;
            }
            catch (ItemNotFoundException e) {
                logger.warn("A default template has been set on site '" + site.getName() + "' but the template has been deleted");
            }
            for (String installedModule : installedModules) {
                JahiaTemplatesPackage aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(installedModule);
                if (aPackage == null) continue;
                this.addTemplates(tmpVs, "/modules/" + installedModule + "/" + aPackage.getVersion(), session, node, nodetype, templateType, defaultTemplate, epd, locale, context);
            }
            if (context.get("contextNode") == null) {
                QueryWrapper queryPageModels = session.getWorkspace().getQueryManager().createQuery("select * from [jmix:canBeUseAsTemplateModel] as tpl where isdescendantnode(tpl,['" + site.getPath() + "'])", "JCR-SQL2");
                QueryResult qrPageModels = queryPageModels.execute();
                NodeIterator niPageModels = qrPageModels.getNodes();
                ArrayList<Node> templateNodes = new ArrayList<Node>();
                while (niPageModels.hasNext()) {
                    Node n = niPageModels.nextNode();
                    if (node.getPath().startsWith(n.getPath()) || n.isNodeType("jmix:markedForDeletion")) continue;
                    templateNodes.add(n);
                }
                if (templateNodes.size() > 0) {
                    vs.add(new ChoiceListValue(Messages.getInternal("org.jahia.services.content.nodetypes.initializers.templates.title", locale), ""));
                    Collections.sort(tmpVs);
                    vs.addAll(tmpVs);
                    vs.add(new ChoiceListValue(Messages.getInternal("org.jahia.services.content.nodetypes.initializers.pageModels.title", locale), ""));
                    tmpVs.clear();
                    for (Node templateNode : templateNodes) {
                        String title = templateNode.hasProperty("j:pageTemplateTitle") ? templateNode.getProperty("j:pageTemplateTitle").getString() : templateNode.getName();
                        ChoiceListValue templateModelValue = new ChoiceListValue(" " + title, templateNode.getPath());
                        templateModelValue.addProperty("addMixin", "jmix:createdFromPageModel");
                        tmpVs.add(templateModelValue);
                    }
                }
            }
            Collections.sort(tmpVs);
            vs.addAll(tmpVs);
        }
        catch (RepositoryException e) {
            logger.error("Cannot get template", (Throwable)e);
        }
        return vs;
    }

    private void addTemplates(List<ChoiceListValue> vs, String path, JCRSessionWrapper session, JCRNodeWrapper node, ExtendedNodeType nodetype, String templateType, String defaultTemplate, ExtendedPropertyDefinition propertyDefinition, Locale locale, Map<String, Object> context) throws RepositoryException {
        List<JCRNodeWrapper> nodes = RenderService.getInstance().getTemplateNodes(null, path, "jnt:" + templateType, false, session);
        for (JCRNodeWrapper templateNode : nodes) {
            boolean ok = true;
            if (templateNode.hasProperty("j:applyOn")) {
                JCRValueWrapper[] types;
                ok = false;
                for (JCRValueWrapper value : types = templateNode.getProperty("j:applyOn").getValues()) {
                    if (!nodetype.isNodeType(value.getString())) continue;
                    ok = true;
                    break;
                }
                if (types.length == 0) {
                    ok = true;
                }
            }
            if (ok && templateNode.hasProperty("j:hiddenTemplate")) {
                boolean bl = ok = !templateNode.getProperty("j:hiddenTemplate").getBoolean();
            }
            if ("pageTemplate".equals(templateType)) {
                ok &= node.getResolveSite().hasPermission("template-" + templateNode.getName());
            }
            if (!ok && context.get("contextNode") != null && node.hasProperty("j:templateName")) {
                try {
                    if (node.getProperty("j:templateName").getString() != null && node.getProperty("j:templateName").getString().equals(templateNode.getName())) {
                        ok = true;
                    }
                }
                catch (ItemNotFoundException infe) {
                    ok = false;
                }
            }
            if (!ok) continue;
            String templateName = templateNode.getName();
            try {
                String templateTitle;
                Property templateTitleProperty = templateNode.getI18N(locale).getProperty("jcr:title");
                if (templateTitleProperty != null && StringUtils.isNotEmpty((String)(templateTitle = templateTitleProperty.getString()))) {
                    templateName = templateTitle;
                }
            }
            catch (RepositoryException re) {
                logger.debug("No title for template " + templateNode.getPath() + " in locale " + locale + ", will use template system name as display name");
            }
            ChoiceListValue v = propertyDefinition.getRequiredType() == 1 ? new ChoiceListValue(templateName, null, session.getValueFactory().createValue(templateNode.getName(), 1)) : new ChoiceListValue(templateName, null, session.getValueFactory().createValue(templateNode.getIdentifier(), 10));
            if (StringUtils.equals((String)templateNode.getName(), (String)defaultTemplate)) {
                v.addProperty("defaultProperty", true);
            }
            if (templateNode.isNodeType("jnt:pageTemplate") && templateNode.hasProperty("j:templateThumbnail")) {
                v.addProperty("image", ((JCRFileNode)templateNode.getProperty("j:templateThumbnail").getNode()).getUrl());
            }
            vs.add(v);
        }
    }
}

