/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.rules.AbstractNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.DeletedNodeFact;
import org.jahia.services.content.rules.ModifiedNodeFact;
import org.jahia.services.content.rules.Updateable;
import org.jahia.services.content.rules.UpdateableWithNewFacts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddedNodeFact
extends AbstractNodeFact
implements UpdateableWithNewFacts,
ModifiedNodeFact {
    private static final Logger logger = LoggerFactory.getLogger(AddedNodeFact.class);
    private AddedNodeFact parentNode;
    private String parentNodePath;
    private String name;
    private String type;
    private boolean insert = false;

    static boolean isLocked(JCRNodeWrapper node) throws AccessDeniedException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        boolean locked = node.isLocked();
        if (locked) {
            Lock lock = node.getLock();
            locked = !node.getSession().isSystem() && (lock == null || !lock.isLockOwningSession());
        }
        return locked;
    }

    public AddedNodeFact(JCRNodeWrapper node) throws RepositoryException {
        super(node);
    }

    public AddedNodeFact(AddedNodeFact parentNodeWrapper, String name, String type, KnowledgeHelper drools) throws RepositoryException {
        this(parentNodeWrapper, name, type, drools, false);
    }

    public AddedNodeFact(AddedNodeFact parentNodeWrapper, String name, String type, KnowledgeHelper drools, boolean insert) throws RepositoryException {
        super(null);
        this.parentNode = parentNodeWrapper;
        this.insert = insert;
        this.workspace = this.parentNode.getNode().getSession().getWorkspace().getName();
        JCRNodeWrapper node = this.parentNode.getNode();
        this.parentNodePath = node.getPath();
        this.name = name;
        if (type == null) {
            ExtendedNodeDefinition end = node.getPrimaryNodeType().getChildNodeDefinitionsAsMap().get(name);
            ExtendedNodeType nodetype = end.getRequiredPrimaryTypes()[0];
            type = nodetype.getName();
        }
        this.type = type;
        if (AddedNodeFact.isLocked(node)) {
            logger.debug("Node is locked, delay property update to later");
            List list = (List)drools.getWorkingMemory().getGlobal("delayedUpdates");
            list.add(this);
        } else {
            if (node.isVersioned()) {
                node.checkout();
            }
            this.node = node.addNode(JCRContentUtils.findAvailableNodeName(node, name), type);
            if (insert) {
                drools.insert((Object)name);
            }
        }
    }

    @Override
    public void doUpdate(JCRSessionWrapper s, List<Updateable> delayedUpdates) throws RepositoryException {
        this.doUpdate(s, delayedUpdates, null);
    }

    @Override
    public void doUpdate(JCRSessionWrapper s, List<Updateable> delayedUpdates, List<Object> newFacts) throws RepositoryException {
        try {
            JCRNodeWrapper node = s.getNode(this.parentNodePath);
            if (AddedNodeFact.isLocked(node)) {
                logger.debug("Node is still locked, delay subnode creation to later");
                delayedUpdates.add(this);
            } else {
                this.node = node.addNode(this.name, this.type);
                if (this.insert && newFacts != null) {
                    newFacts.add(this);
                }
            }
        }
        catch (PathNotFoundException e) {
            logger.warn("Node does not exist " + this.parentNodePath);
        }
    }

    @Override
    public String getPath() throws RepositoryException {
        if (this.node != null) {
            return this.node.getPath();
        }
        if (this.parentNodePath != null && this.name != null) {
            return this.parentNodePath + "/" + this.name;
        }
        return null;
    }

    @Override
    public String getName() throws RepositoryException {
        if (this.node != null) {
            return this.node.getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return null;
    }

    @Override
    public List<ChangedPropertyFact> getProperties() throws RepositoryException {
        ArrayList<ChangedPropertyFact> results = new ArrayList<ChangedPropertyFact>();
        PropertyIterator it = this.node.getProperties();
        while (it.hasNext()) {
            JCRPropertyWrapper p = (JCRPropertyWrapper)it.nextProperty();
            results.add(new ChangedPropertyFact(this, p));
        }
        return results;
    }

    @Override
    public ChangedPropertyFact getProperty(String propertyName) throws RepositoryException {
        return new ChangedPropertyFact(this, this.node.getProperty(propertyName));
    }

    public long getNumberOfChildren() throws RepositoryException {
        return this.node.getNodes().getSize();
    }

    public void addType(String type, KnowledgeHelper drools) throws RepositoryException {
        if (this.node.isNodeType(type)) {
            return;
        }
        this.node.checkout();
        this.node.addMixin(type);
        drools.insert((Object)new ChangedPropertyFact(this, this.node.getProperty("jcr:mixinTypes")));
        this.node.getSession().save();
    }

    public void removeType(String type, KnowledgeHelper drools) throws RepositoryException {
        this.node.checkout();
        this.node.removeMixin(type);
        try {
            JCRPropertyWrapper property = this.node.getProperty("jcr:mixinTypes");
            drools.insert((Object)new ChangedPropertyFact(this, property));
        }
        catch (PathNotFoundException e) {
            drools.insert((Object)new DeletedNodeFact(this, "jcr:mixinTypes"));
        }
        this.node.getSession().save();
    }

    @Override
    public AddedNodeFact getAncestor(String type) throws RepositoryException {
        AddedNodeFact ancestor = this;
        try {
            while ((ancestor = ancestor.getParent()) != null) {
                if (!ancestor.getNode().isNodeType(type)) continue;
                return ancestor;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return this.node.getPath();
    }

    @Override
    public boolean equals(Object o) {
        if (logger.isDebugEnabled()) {
            logger.debug("Checking if " + this.toString() + " is equal to " + o.toString());
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddedNodeFact that = (AddedNodeFact)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.node != null ? !this.node.equals(that.node) : that.node != null) {
            return false;
        }
        if (this.parentNode != null ? !this.parentNode.equals(that.parentNode) : that.parentNode != null) {
            return false;
        }
        if (this.parentNodePath != null ? !this.parentNodePath.equals(that.parentNodePath) : that.parentNodePath != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    @Override
    public int hashCode() {
        if (logger.isDebugEnabled()) {
            logger.debug("Requesting hashcode for AddedNodeFact " + this.toString());
        }
        int result = this.parentNode != null ? this.parentNode.hashCode() : 0;
        result = 31 * result + (this.parentNodePath != null ? this.parentNodePath.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
        return result;
    }

    @Override
    public String getIdentifier() throws RepositoryException {
        return this.node != null ? this.node.getIdentifier() : null;
    }

    @Override
    public String getNodeIdentifier() throws RepositoryException {
        return this.getIdentifier();
    }

    @Override
    public String getNodeType() throws RepositoryException {
        return this.getNode().getPrimaryNodeTypeName();
    }
}

