/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.rules.AddedNodeFact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopiedNodeFact
extends AddedNodeFact {
    private static Logger logger = LoggerFactory.getLogger(CopiedNodeFact.class);
    private String originalPath;
    private String sourceUuid;
    private boolean top;

    public CopiedNodeFact(JCRNodeWrapper node, String sourceUuid, boolean top) throws RepositoryException {
        super(node);
        this.sourceUuid = sourceUuid;
        this.top = top;
    }

    public String getOriginalPath() {
        if (this.originalPath == null && this.node != null && this.sourceUuid != null) {
            try {
                this.originalPath = this.node.getSession().getNodeByIdentifier(this.sourceUuid).getPath();
            }
            catch (RepositoryException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.originalPath;
    }

    public boolean isTop() {
        return this.top;
    }

    @Override
    public String toString() {
        return "copied " + this.node.getPath();
    }
}

