/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.files.FileCacheManager;
import org.jahia.services.content.rules.BaseBackgroundAction;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class FlushCacheOnNodeBackgroundAction
extends BaseBackgroundAction {
    private static Logger logger = LoggerFactory.getLogger(FlushCacheOnNodeBackgroundAction.class);
    private FileCacheManager fileCacheManager = FileCacheManager.getInstance();
    private ModuleCacheProvider cacheProvider;
    private URLResolverFactory urlResolverFactory;
    private int startLevel;
    private int levelsUp;
    private String eventMessage;

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    @Override
    public void executeBackgroundAction(JCRNodeWrapper node) {
        String workspace = "live";
        boolean log = logger.isDebugEnabled();
        try {
            JCRNodeWrapper currentNode = node;
            workspace = node.getSession().getWorkspace().getName();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    String path = currentNode.getPath();
                    this.cacheProvider.invalidate(path);
                    this.cacheProvider.invalidate(currentNode.getIdentifier());
                    if (log) {
                        logger.debug("Flushed output caches for node {}", (Object)path);
                    }
                    if (currentNode.isFile()) {
                        this.fileCacheManager.invalidate(workspace, path);
                        if (log) {
                            logger.debug("Flushed file cache for node {}", (Object)path);
                        }
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(path, true);
                    if (log) {
                        logger.debug("Flushed regexp dependencies for node {}", (Object)path);
                    }
                    this.urlResolverFactory.flushCaches(path);
                    if (log) {
                        logger.debug("Flushed url resolver cache for node {}", (Object)path);
                    }
                }
                currentNode = currentNode.getParent();
            }
        }
        catch (RepositoryException e) {
            String currentNodePath = node.getPath();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    this.cacheProvider.invalidate(currentNodePath);
                    this.fileCacheManager.invalidate(workspace, currentNodePath);
                    if (log) {
                        logger.debug("Flushed output and file caches for node {}", (Object)currentNodePath);
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(currentNodePath, true);
                    if (log) {
                        logger.debug("Flushed regexp dependencies for node {}", (Object)currentNodePath);
                    }
                    this.urlResolverFactory.flushCaches(currentNodePath);
                    if (log) {
                        logger.debug("Flushed url resolver cache for node {}", (Object)currentNodePath);
                    }
                }
                currentNodePath = StringUtils.substringBeforeLast((String)currentNodePath, (String)"/");
            }
        }
        if (this.eventMessage != null) {
            CacheFlushedEvent event = new CacheFlushedEvent(node.getPath(), this.eventMessage, this.startLevel, this.levelsUp);
            SpringContextSingleton.getInstance().publishEvent(event);
            FrameworkService.sendEvent("org/jahia/services/content/rules/cacheFlushed", event.toMap(), true);
        }
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setLevelsUp(int endLevel) {
        this.levelsUp = endLevel;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public static class CacheFlushedEvent
    extends ApplicationEvent {
        public static final String TOPIC = "org/jahia/services/content/rules/cacheFlushed";
        private String reason;
        private int startLevel;
        private int levelsUp;

        public CacheFlushedEvent(String path, String reason, int startLevel, int levelsUp) {
            super((Object)path);
            this.reason = reason;
            this.startLevel = startLevel;
            this.levelsUp = levelsUp;
        }

        public String getPath() {
            return (String)this.getSource();
        }

        public String getReason() {
            return this.reason;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public int getLevelsUp() {
            return this.levelsUp;
        }

        public Map<String, Object> toMap() {
            return Collections.singletonMap("event", this);
        }
    }
}

