/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanedActionPurgeJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(OrphanedActionPurgeJob.class);

    @Override
    public void executeJahiaJob(JobExecutionContext ctx) throws Exception {
        long timer = System.currentTimeMillis();
        JobDataMap data = ctx.getJobDetail().getJobDataMap();
        final String workspace = StringUtils.defaultIfEmpty((String)data.getString("workspace"), (String)"live");
        final Set<String> jobGroupNames = this.getJobGroupNames(data);
        if (jobGroupNames == null || jobGroupNames.isEmpty()) {
            logger.debug("No job group names to scan. Skipping.");
            return;
        }
        Integer[] counts = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<Integer[]>(){

            @Override
            public Integer[] doInJCR(JCRSessionWrapper session) throws RepositoryException {
                logger.info("Start looking for orphaned action jobs in job groups {} and workspace {}", (Object)jobGroupNames, (Object)workspace);
                return OrphanedActionPurgeJob.this.processJobs(jobGroupNames, session);
            }
        });
        logger.info("Finished scanning {} action jobs. Deleted {} orphaned jobs. Execution took {} ms", (Object[])new Long[]{(long)counts[0], (long)counts[1], System.currentTimeMillis() - timer});
    }

    protected Set<String> getJobGroupNames(JobDataMap data) {
        Object val = data.get((Object)"jobGroupNames");
        return val != null && val instanceof Set ? (Set)val : null;
    }

    private boolean jobValid(String uuid, JCRSessionWrapper session) throws RepositoryException {
        if (uuid != null) {
            try {
                session.getNodeByIdentifier(uuid);
            }
            catch (ItemNotFoundException e) {
                uuid = null;
            }
        }
        return uuid != null;
    }

    private Integer[] processJobs(Set<String> jobGroupNames, JCRSessionWrapper session) {
        Scheduler scheduler = ServicesRegistry.getInstance().getSchedulerService().getScheduler();
        Integer[] counts = new Integer[]{0, 0};
        try {
            for (String group : scheduler.getTriggerGroupNames()) {
                String[] triggerNames;
                for (String triggerName : triggerNames = scheduler.getTriggerNames(group)) {
                    try {
                        JobDetail job;
                        Trigger trigger = scheduler.getTrigger(triggerName, group);
                        if (trigger == null || !jobGroupNames.contains(trigger.getJobGroup()) || (job = scheduler.getJobDetail(trigger.getJobName(), trigger.getJobGroup())) == null) continue;
                        Integer n = counts[0];
                        Integer n2 = counts[0] = Integer.valueOf(counts[0] + 1);
                        String uuid = job.getJobDataMap().getString("node");
                        if (this.jobValid(uuid, session)) continue;
                        n2 = counts[1];
                        Integer n3 = counts[1] = Integer.valueOf(counts[1] + 1);
                        logger.info("Found orhpaned job {} with node UUID {}. Deleting job.", (Object)job.getFullName(), (Object)uuid);
                        scheduler.deleteJob(job.getName(), job.getGroup());
                    }
                    catch (Exception e) {
                        logger.warn("Error handling trigger " + group + "." + triggerName, (Throwable)e);
                    }
                }
            }
        }
        catch (SchedulerException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return counts;
    }
}

