/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import java.util.Set;
import org.jahia.services.history.NodeVersionHistoryHelper;
import org.jahia.services.history.VersionHistoryCheckStatus;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeVersionHistoryJob
extends BackgroundJob {
    static final String JOB_SITE = "site";
    public static final String JOB_NODE_IDS = "nodeIds";
    private static Logger logger = LoggerFactory.getLogger(NodeVersionHistoryJob.class);

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDataMap data = jobExecutionContext.getJobDetail().getJobDataMap();
        String site = (String)data.get((Object)JOB_SITE);
        Set ids = (Set)data.get((Object)JOB_NODE_IDS);
        long timer = System.currentTimeMillis();
        VersionHistoryCheckStatus status = NodeVersionHistoryHelper.purgeVersionHistoryForNodes(ids);
        logger.info("Purged version histories for nodes of the site {} in {} ms. Status: {}", (Object[])new String[]{site, String.valueOf(System.currentTimeMillis() - timer), status.toString()});
    }
}

