/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.image.BufferImage;
import org.jahia.services.image.Image;
import org.jahia.services.image.ImageJImageService;
import org.jahia.services.image.JahiaImageService;
import org.jahia.services.image.Java2DProgressiveBilinearImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageJAndJava2DImageService
extends Java2DProgressiveBilinearImageService {
    private ImageJImageService imageJImageService = ImageJImageService.getInstance();
    private static ImageJAndJava2DImageService instance = new ImageJAndJava2DImageService();
    private static final Logger logger = LoggerFactory.getLogger(ImageJAndJava2DImageService.class);

    private ImageJAndJava2DImageService() {
    }

    public void init() {
    }

    public static ImageJAndJava2DImageService getInstance() {
        return instance;
    }

    @Override
    public Image getImage(JCRNodeWrapper node) throws IOException, RepositoryException {
        if (super.canRead(node)) {
            return super.getImage(node);
        }
        return this.imageJImageService.getImage(node);
    }

    @Override
    public boolean createThumb(Image iw, File outputFile, int size, boolean square) throws IOException {
        if (iw instanceof BufferImage) {
            return super.createThumb(iw, outputFile, size, square);
        }
        return this.imageJImageService.createThumb(iw, outputFile, size, square);
    }

    @Override
    public int getHeight(Image i) {
        if (i instanceof BufferImage) {
            return super.getHeight(i);
        }
        return this.imageJImageService.getHeight(i);
    }

    @Override
    public int getWidth(Image i) {
        if (i instanceof BufferImage) {
            return super.getWidth(i);
        }
        return this.imageJImageService.getWidth(i);
    }

    @Override
    public boolean cropImage(Image image, File outputFile, int top, int left, int width, int height) throws IOException {
        if (image instanceof BufferImage) {
            return super.cropImage(image, outputFile, top, left, width, height);
        }
        logger.info("Using ImageJ code for file " + image.getPath() + "...");
        return this.imageJImageService.cropImage(image, outputFile, top, left, width, height);
    }

    @Override
    public boolean rotateImage(Image image, File outputFile, boolean clockwise) throws IOException {
        if (image instanceof BufferImage) {
            return super.rotateImage(image, outputFile, clockwise);
        }
        return this.imageJImageService.rotateImage(image, outputFile, clockwise);
    }

    @Override
    public boolean resizeImage(Image image, File outputFile, int newWidth, int newHeight, JahiaImageService.ResizeType resizeType) throws IOException {
        if (image instanceof BufferImage) {
            return super.resizeImage(image, outputFile, newWidth, newHeight, resizeType);
        }
        return this.imageJImageService.resizeImage(image, outputFile, newWidth, newHeight, resizeType);
    }

    @Override
    public BufferedImage resizeImage(BufferedImage image, int width, int height, JahiaImageService.ResizeType resizeType) {
        return super.resizeImage(image, width, height, resizeType);
    }
}

