/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.ImageCommand;
import org.im4java.core.Operation;
import org.im4java.core.Stream2BufferedImage;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.im4java.process.ProcessStarter;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.image.AbstractImageService;
import org.jahia.services.image.Image;
import org.jahia.services.image.ImageMagickImage;
import org.jahia.services.image.JahiaImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMagickImageService
extends AbstractImageService {
    private static final Logger logger = LoggerFactory.getLogger(ImageMagickImageService.class);
    private static ImageMagickImageService instance = new ImageMagickImageService();
    private String imageMagickPath;

    protected ImageMagickImageService() {
    }

    public void init() {
        ProcessStarter.setGlobalSearchPath((String)this.imageMagickPath);
    }

    public static ImageMagickImageService getInstance() {
        return instance;
    }

    public void setImageMagickPath(String imageMagickPath) {
        this.imageMagickPath = imageMagickPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage(JCRNodeWrapper node) throws IOException, RepositoryException {
        JCRNodeWrapper contentNode = node.getNode("jcr:content");
        String fileExtension = FilenameUtils.getExtension((String)node.getName());
        File tmp = File.createTempFile("image", StringUtils.isNotEmpty((String)fileExtension) ? "." + fileExtension : null);
        InputStream is = contentNode.getProperty("jcr:data").getStream();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        }
        return new ImageMagickImage(tmp, node.getPath());
    }

    protected void readDimensions(ImageMagickImage img) {
        long timer = System.currentTimeMillis();
        try {
            IMOperation op = new IMOperation();
            op.format("%w\n%h");
            op.addImage(new String[]{img.getFile().getPath()});
            ImageCommand identify = new ImageCommand();
            identify.setCommand(new String[]{"magick", "identify"});
            ArrayListOutputConsumer output = new ArrayListOutputConsumer();
            identify.setOutputConsumer((OutputConsumer)output);
            identify.run((Operation)op, new Object[0]);
            ArrayList cmdOutput = output.getOutput();
            img.setWidth(Integer.parseInt((String)cmdOutput.get(0)));
            img.setHeight(Integer.parseInt((String)cmdOutput.get(1)));
        }
        catch (Exception e) {
            logger.error("Error retrieving image dimensions for " + img.getPath() + ": " + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.error("Error retrieving image dimensions for " + img.getPath(), (Throwable)e);
            }
            img.setWidth(-1);
            img.setHeight(-1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dimensions read for image {} in {} ms: {} x {}", new Object[]{img.getFile().getPath(), System.currentTimeMillis() - timer, img.getWidth(), img.getHeight()});
        }
    }

    @Override
    public int getHeight(Image i) throws IOException {
        ImageMagickImage img = (ImageMagickImage)i;
        if (img.getHeight() != null) {
            return img.getHeight();
        }
        this.readDimensions(img);
        return img.getHeight();
    }

    @Override
    public int getWidth(Image i) throws IOException {
        ImageMagickImage img = (ImageMagickImage)i;
        if (img.getWidth() != null) {
            return img.getWidth();
        }
        this.readDimensions(img);
        return img.getWidth();
    }

    @Override
    public boolean cropImage(Image i, File outputFile, int top, int left, int width, int height) throws IOException {
        try {
            ConvertCmd cmd = new ConvertCmd();
            IMOperation op = new IMOperation();
            op.addImage(new String[]{((ImageMagickImage)i).getFile().getPath()});
            op.background("none");
            op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(left), Integer.valueOf(top));
            op.p_repage();
            op.addImage(new String[]{outputFile.getPath()});
            cmd.run((Operation)op, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error cropping image " + i.getPath() + " to size " + width + "x" + height + ": " + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("Error cropping image " + i.getPath() + " to size " + width + "x" + height, (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean rotateImage(Image image, File outputFile, boolean clockwise) throws IOException {
        return this.rotateImage(image, outputFile, clockwise ? 90.0 : -90.0);
    }

    @Override
    public boolean rotateImage(Image image, File outputFile, double angle) throws IOException {
        try {
            ConvertCmd cmd = new ConvertCmd();
            IMOperation op = new IMOperation();
            op.addImage(new String[]{((ImageMagickImage)image).getFile().getPath()});
            op.rotate(Double.valueOf(angle));
            op.addImage(new String[]{outputFile.getPath()});
            cmd.run((Operation)op, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error rotating image " + image.getPath(), (Throwable)e);
            if (logger.isDebugEnabled()) {
                logger.debug("Error rotating image " + image.getPath(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean resizeImage(Image i, File outputFile, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        return this.resizeImage(this.getFile(i), outputFile, width, height, resizeType);
    }

    @Override
    public BufferedImage resizeImage(BufferedImage image, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        try {
            IMOperation op = new IMOperation();
            op.addImage();
            this.setupIMResize(op, width, height, resizeType);
            op.addImage(new String[]{"png:-"});
            ConvertCmd convert = new ConvertCmd();
            Stream2BufferedImage s2b = new Stream2BufferedImage();
            convert.setOutputConsumer((OutputConsumer)s2b);
            convert.run((Operation)op, new Object[]{image});
            BufferedImage img = s2b.getImage();
            return img;
        }
        catch (Exception e) {
            logger.error("Error resizing image : " + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("Error resizing image ", (Throwable)e);
            }
            return null;
        }
    }

    protected boolean resizeImage(File inputFile, File outputFile, int width, int height, JahiaImageService.ResizeType resizeType) throws IOException {
        try {
            ConvertCmd cmd = new ConvertCmd();
            IMOperation op = new IMOperation();
            op.addImage(new String[]{inputFile.getPath()});
            this.setupIMResize(op, width, height, resizeType);
            op.addImage(new String[]{outputFile.getPath()});
            cmd.run((Operation)op, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error resizing image " + inputFile + ": " + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("Error resizing image " + inputFile, (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private File getFile(Image i) {
        return ((ImageMagickImage)i).getFile();
    }

    private void setupIMResize(IMOperation op, int width, int height, JahiaImageService.ResizeType resizeType) {
        if (JahiaImageService.ResizeType.ADJUST_SIZE.equals((Object)resizeType)) {
            op.resize(Integer.valueOf(width), Integer.valueOf(height));
        } else if (JahiaImageService.ResizeType.ASPECT_FILL.equals((Object)resizeType)) {
            op.resize(Integer.valueOf(width), Integer.valueOf(height), "^");
            op.gravity("center");
            op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(0), Integer.valueOf(0));
            op.p_repage();
        } else if (JahiaImageService.ResizeType.ASPECT_FIT.equals((Object)resizeType)) {
            op.resize(Integer.valueOf(width), Integer.valueOf(height));
            op.gravity("center");
            op.background("none");
            op.extent(Integer.valueOf(width), Integer.valueOf(height));
        } else {
            op.resize(Integer.valueOf(width), Integer.valueOf(height), "!");
        }
    }
}

