/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.importexport.LegacyPidMappingTool;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyPidToVanityUrlMappingToolImpl
implements LegacyPidMappingTool {
    private static Logger logger = LoggerFactory.getLogger(LegacyPidToVanityUrlMappingToolImpl.class);
    private VanityUrlManager urlMgr;

    public void setUrlMgr(VanityUrlManager urlMgr) {
        this.urlMgr = urlMgr;
    }

    @Override
    public void defineLegacyMapping(int oldPid, JCRNodeWrapper newPageNode, Locale locale) {
        try {
            String url = "/lang/" + locale.toString() + "/pid/" + oldPid;
            String site = newPageNode.getResolveSite().getSiteKey();
            if (this.urlMgr.findExistingVanityUrls(url, site, newPageNode.getSession()).isEmpty()) {
                VanityUrl vanityUrl = new VanityUrl(url, site, locale.toString(), false, true);
                this.urlMgr.saveVanityUrlMapping(newPageNode, vanityUrl, newPageNode.getSession());
            }
        }
        catch (RepositoryException e) {
            logger.error("Issue while creating legacy pid mapping for page " + oldPid, (Throwable)e);
        }
    }
}

