/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.MissingNodetypesValidationResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.xml.sax.Attributes;

public class MissingNodetypesValidator
implements ImportValidator {
    private Set<String> existingNodetypes = new HashSet<String>();
    private Map<String, Set<String>> missingMixins = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> missingNodetypes = new TreeMap<String, Set<String>>();

    private boolean isTypeExisting(String type, boolean mixin) {
        if (this.existingNodetypes.contains(type)) {
            return true;
        }
        if (!mixin && this.missingNodetypes.containsKey(type) || mixin && this.missingMixins.containsKey(type)) {
            return false;
        }
        try {
            NodeTypeRegistry.getInstance().getNodeType(type);
            this.existingNodetypes.add(type);
            return true;
        }
        catch (NoSuchNodeTypeException e) {
            if (!mixin) {
                this.missingNodetypes.put(type, new TreeSet());
            } else {
                this.missingMixins.put(type, new TreeSet());
            }
            return false;
        }
    }

    @Override
    public ValidationResult getResult() {
        return new MissingNodetypesValidationResult(this.missingNodetypes, this.missingMixins);
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        String m;
        String pt = atts.getValue("jcr:primaryType");
        if (pt != null && !this.isTypeExisting(pt, false)) {
            this.missingNodetypes.get(pt).add(currentPath);
        }
        if ((m = atts.getValue("jcr:mixinTypes")) != null) {
            StringTokenizer st = new StringTokenizer(m, " ,");
            while (st.hasMoreTokens()) {
                String mixin = st.nextToken();
                if (this.isTypeExisting(mixin, true)) continue;
                this.missingMixins.get(mixin).add(currentPath);
            }
        }
    }
}

