/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;

public class ProviderAvailabilityValidatorResult
implements ValidationResult,
Serializable {
    private final Set<String> unavailableProviders;

    public ProviderAvailabilityValidatorResult(Set<String> unavailableProviders) {
        this.unavailableProviders = unavailableProviders;
    }

    public ProviderAvailabilityValidatorResult(ProviderAvailabilityValidatorResult result, ProviderAvailabilityValidatorResult toBeMergedWith) {
        this.unavailableProviders = new LinkedHashSet<String>(result.getUnavailableProviders());
        this.unavailableProviders.addAll(toBeMergedWith.getUnavailableProviders());
    }

    @Override
    public boolean isSuccessful() {
        return this.unavailableProviders.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof ProviderAvailabilityValidatorResult) ? this : new ProviderAvailabilityValidatorResult(this, (ProviderAvailabilityValidatorResult)toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        out.append(", unavailableProviders=").append(this.unavailableProviders);
        out.append("]");
        return out.toString();
    }

    public Set<String> getUnavailableProviders() {
        return this.unavailableProviders;
    }
}

