/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;

public class UserValidatorResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = 2598819850670436530L;
    private Set<String> duplicateUsers = new TreeSet<String>();

    public UserValidatorResult(Set<String> duplicateUsers) {
        this.duplicateUsers = duplicateUsers;
    }

    public Set<String> getDuplicateUsers() {
        return this.duplicateUsers;
    }

    @Override
    public boolean isSuccessful() {
        return this.duplicateUsers.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    public String getMessageKey() {
        return "failure.import.conflictingUser";
    }

    public List<Object> getMessageParams() {
        String res = this.duplicateUsers.size() > 10 ? StringUtils.join((Object[])this.duplicateUsers.toArray(new String[this.duplicateUsers.size()]), (String)",", (int)0, (int)10) + " ..." : StringUtils.join(this.duplicateUsers, (String)",");
        return Arrays.asList(this.duplicateUsers.size(), res);
    }
}

