/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.logging;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.logging.MetricsLoggingService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLoggingJCReventListener
extends DefaultEventListener {
    private static transient Logger logger = LoggerFactory.getLogger(MetricsLoggingJCReventListener.class);
    private MetricsLoggingService loggingService;
    private List<String> nodeTypesList = null;

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public void setNodeTypesList(List<String> nodeTypes) {
        if (nodeTypes != null && nodeTypes.size() > 0) {
            this.nodeTypesList = nodeTypes;
        }
    }

    @Override
    public int getEventTypes() {
        return this.loggingService.isEnabled() ? 63 : 0;
    }

    @Override
    public String[] getNodeTypes() {
        return this.nodeTypesList == null || this.nodeTypesList.isEmpty() ? null : this.nodeTypesList.toArray(new String[this.nodeTypesList.size()]);
    }

    public void onEvent(EventIterator events) {
        if (events instanceof JCREventIterator && ((JCREventIterator)events).getOperationType() == 13) {
            return;
        }
        while (events.hasNext()) {
            try {
                Event event = events.nextEvent();
                switch (event.getType()) {
                    case 1: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "nodeCreated", this.getInfoAsJson(event));
                        break;
                    }
                    case 32: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "nodeMoved", this.getInfoAsJson(event));
                        break;
                    }
                    case 2: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "nodeDeleted", this.getInfoAsJson(event));
                        break;
                    }
                    case 4: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "propertyAdded", this.getInfoAsJson(event));
                        break;
                    }
                    case 16: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "propertyChanged", this.getInfoAsJson(event));
                        break;
                    }
                    case 8: {
                        this.loggingService.logContentEvent(event.getUserID(), "", "", event.getIdentifier(), event.getPath(), this.getNodeType(event), "propertyRemoved", this.getInfoAsJson(event));
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getInfoAsJson(Event event) throws RepositoryException {
        Map info = event.getInfo();
        return info != null && info.size() > 0 ? new JSONObject(info).toString() : "{}";
    }

    private String getNodeType(Event event) {
        List<String> nodeTypes;
        String nodeType = null;
        if (event instanceof JCRObservationManager.EventWrapper && (nodeTypes = ((JCRObservationManager.EventWrapper)event).getNodeTypes()) != null && nodeTypes.size() > 0) {
            nodeType = nodeTypes.get(0);
        }
        return nodeType != null ? nodeType : "";
    }
}

