/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.mail;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;

public class MailMessage {
    private Map<String, DataHandler> attachments = new HashMap<String, DataHandler>();
    private String bcc;
    private String cc;
    private String from;
    private String htmlBody;
    private String subject;
    private String textBody;
    private String to;

    public static Builder newMessage() {
        return new Builder();
    }

    public MailMessage() {
    }

    public MailMessage(MailMessage msg) {
        this();
        this.attachments.putAll(msg.getAttachments());
        this.setBcc(msg.getBcc());
        this.setCc(msg.getCc());
        this.setFrom(msg.getFrom());
        this.setHtmlBody(msg.getHtmlBody());
        this.setSubject(msg.getSubject());
        this.setTextBody(msg.getTextBody());
        this.setTo(msg.getTo());
    }

    public Map<String, DataHandler> getAttachments() {
        return this.attachments;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getCc() {
        return this.cc;
    }

    public String getFrom() {
        return this.from;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public String getTo() {
        return this.to;
    }

    public void setAttachments(Map<String, DataHandler> attachments) {
        this.attachments = attachments != null ? attachments : new HashMap();
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public static class Builder {
        private MailMessage msg = new MailMessage();

        protected Builder() {
        }

        public Builder attachment(String id, DataHandler handler) {
            this.msg.getAttachments().put(id, handler);
            return this;
        }

        public Builder attachments(Map<String, DataHandler> attachments) {
            this.msg.setAttachments(attachments);
            return this;
        }

        public Builder bcc(String bcc) {
            this.msg.setBcc(bcc);
            return this;
        }

        public MailMessage build() {
            return new MailMessage(this.msg);
        }

        public Builder cc(String cc) {
            this.msg.setCc(cc);
            return this;
        }

        public Builder from(String from) {
            this.msg.setFrom(from);
            return this;
        }

        public Builder htmlBody(String htmlBody) {
            this.msg.setHtmlBody(htmlBody);
            return this;
        }

        public Builder subject(String subject) {
            this.msg.setSubject(subject);
            return this;
        }

        public Builder textBody(String textBody) {
            this.msg.setTextBody(textBody);
            return this;
        }

        public Builder to(String to) {
            this.msg.setTo(to);
            return this;
        }
    }
}

