/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.modulemanager.BundleBucketInfo;
import org.osgi.framework.Bundle;

public class BundleInfo
implements Serializable {
    private static final long serialVersionUID = -2594724069028562931L;
    private BundleBucketInfo bucketInfo;
    private String version;

    public static BundleInfo fromBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null");
        }
        return new BundleInfo(BundleUtils.getModuleGroupId(bundle), bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    public static BundleInfo fromKey(String key) {
        if (key == null || key.indexOf(47) == -1) {
            throw new IllegalArgumentException("Illegal bundle key: " + key);
        }
        String bucketKey = StringUtils.substringBeforeLast((String)key, (String)"/");
        String version = StringUtils.substringAfterLast((String)key, (String)"/");
        BundleBucketInfo bucketInfo = BundleBucketInfo.fromKey(bucketKey);
        return new BundleInfo(bucketInfo, version);
    }

    public static BundleInfo fromModuleInfo(String moduleId, String moduleVersion) {
        if (moduleId == null || moduleVersion == null) {
            throw new IllegalArgumentException("Illegal module info (id/version): " + moduleId + '/' + moduleVersion);
        }
        Bundle bundle = BundleUtils.getBundle(moduleId, moduleVersion);
        return bundle != null ? BundleInfo.fromBundle(bundle) : null;
    }

    public BundleInfo(String symbolicName, String version) {
        this(null, symbolicName, version);
    }

    public BundleInfo(String groupId, String symbolicName, String version) {
        this(new BundleBucketInfo(groupId, symbolicName), version);
    }

    public BundleInfo(BundleBucketInfo bucketInfo, String version) {
        if (bucketInfo == null || version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Bundle bucket info and bundle version are required");
        }
        this.bucketInfo = bucketInfo;
        this.version = version;
    }

    public String getGroupId() {
        return this.bucketInfo.getGroupId();
    }

    public String getKey() {
        return this.bucketInfo.getKey() + '/' + this.version;
    }

    public String getSymbolicName() {
        return this.bucketInfo.getSymbolicName();
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass() && ((BundleInfo)obj).getKey().equals(this.getKey());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

