/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.models;

import org.apache.commons.lang.StringUtils;
import org.apache.felix.utils.version.VersionCleaner;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class JahiaDepends {
    private String moduleName = "";
    private VersionRange range = null;
    private String parsedString = null;

    public JahiaDepends(String dependency) {
        this.parsedString = dependency;
        String[] deps = dependency.split("=");
        String string = this.moduleName = StringUtils.isNotBlank((String)deps[0]) ? deps[0].trim() : "";
        if (deps.length > 1 && StringUtils.isNotBlank((String)deps[1])) {
            this.range = VersionRange.valueOf((String)deps[1]);
        }
    }

    public boolean hasVersion() {
        return StringUtils.isNotEmpty((String)this.getMinVersion()) || StringUtils.isNotEmpty((String)this.getMaxVersion());
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getMinVersion() {
        return this.range != null && this.range.getLeft() != null ? this.range.getLeft().toString() : "";
    }

    public String getMaxVersion() {
        return this.range != null && this.range.getRight() != null ? this.range.getRight().toString() : "";
    }

    public VersionRange getVersionRange() {
        return this.range;
    }

    public boolean inRange(String version) {
        Version v = new Version(JahiaDepends.toOsgiVersion(version));
        return this.range == null || this.range.includes(v);
    }

    public String toFilterString() {
        String verFilter = this.range != null ? this.range.toFilterString("moduleVersion") : "";
        String filter = String.format("(%s=%s)", "moduleIdentifier", this.moduleName);
        if (!verFilter.isEmpty()) {
            filter = verFilter.startsWith("(&") ? verFilter.replace("&", "&" + filter) : String.format("(&%s%s)", filter, verFilter);
        }
        return filter;
    }

    public static JahiaDepends parse(String dependency) {
        return new JahiaDepends(dependency);
    }

    public static String toOsgiVersion(String version) {
        return VersionCleaner.clean((String)version);
    }

    public static boolean isOpenClause(String clause) {
        return StringUtils.isNotBlank((String)clause) && (clause.trim().startsWith(String.valueOf('(')) || clause.trim().startsWith(String.valueOf('[')));
    }

    public String toString() {
        return this.parsedString;
    }
}

