/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.jahia.services.pwdpolicy.ConditionEvaluator;
import org.jahia.services.pwdpolicy.EvaluationContext;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicy;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyRule;
import org.jahia.services.pwdpolicy.JavaConditionEvaluator;
import org.jahia.services.pwdpolicy.PolicyEnforcementResult;

final class PolicyEvaluator {
    private static final Map<Character, ConditionEvaluator> EVALUATORS;

    PolicyEvaluator() {
    }

    static PolicyEnforcementResult evaluate(JahiaPasswordPolicy policy, EvaluationContext ctx, boolean periodicalRulesOnly) {
        PolicyEnforcementResult result = PolicyEnforcementResult.SUCCESS;
        LinkedList<JahiaPasswordPolicyRule> violatedRules = new LinkedList<JahiaPasswordPolicyRule>();
        for (JahiaPasswordPolicyRule rule : policy.getRules()) {
            if (!rule.isActive() || rule.isPeriodical() != periodicalRulesOnly || PolicyEvaluator.evaluateRule(rule, ctx)) continue;
            violatedRules.add(rule);
            if (!rule.isLastRule()) continue;
            break;
        }
        if (violatedRules.size() > 0) {
            result = new PolicyEnforcementResult(violatedRules);
        }
        return result;
    }

    private static boolean evaluateRule(JahiaPasswordPolicyRule rule, EvaluationContext ctx) {
        return PolicyEvaluator.getEvaluator(rule.getEvaluator()).evaluate(rule, ctx);
    }

    private static ConditionEvaluator getEvaluator(char type) {
        ConditionEvaluator evaluator = EVALUATORS.get(new Character(type));
        if (evaluator == null) {
            throw new UnsupportedOperationException("Not supported evaluator type '" + type + "'");
        }
        return evaluator;
    }

    static {
        FastHashMap evals = new FastHashMap(1);
        evals.put((Object)new Character('J'), (Object)new JavaConditionEvaluator());
        evals.setFast(true);
        EVALUATORS = evals;
    }
}

