/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.services.render.filter.RenderChain;

public class URLSystemAttributesAppenderFilter
extends AbstractFilter {
    private List<String> attributesToKeep;
    private HtmlTagAttributeTraverser traverser;
    private boolean alwaysIncludeAllParams = false;

    public void setAttributesToKeep(List<String> attributesToKeep) {
        this.attributesToKeep = attributesToKeep;
    }

    public void setAlwaysIncludeAllParams(boolean alwaysIncludeAllParams) {
        this.alwaysIncludeAllParams = alwaysIncludeAllParams;
    }

    @Override
    public String execute(String previousOut, final RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (this.alwaysIncludeAllParams || !Collections.disjoint(this.attributesToKeep, renderContext.getRequest().getParameterMap().keySet())) {
            previousOut = this.traverser.traverse(previousOut, renderContext, resource, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

                @Override
                public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
                    if (!(value.startsWith("javascript:") || value.startsWith("#") || value.contains("##requestParameters##"))) {
                        String urlContext = renderContext.getURLGenerator().getContext();
                        Map parameterMap = renderContext.getRequest().getParameterMap();
                        StringBuilder newValue = new StringBuilder(30 * parameterMap.size());
                        newValue.append(value);
                        String separateChar = value.contains("?") ? "&" : "?";
                        for (String s : URLSystemAttributesAppenderFilter.this.attributesToKeep) {
                            String parameter;
                            if (s.contains("*")) {
                                if (!value.startsWith(urlContext) || value.matches(s.replace("*", ".*="))) continue;
                                for (String paramName : parameterMap.keySet()) {
                                    String parameter2;
                                    if (!paramName.matches(s.replace("*", ".*")) || (parameter2 = renderContext.getRequest().getParameter(paramName)) == null) continue;
                                    newValue.append(separateChar).append(paramName).append("=").append(parameter2);
                                    separateChar = "&";
                                }
                                continue;
                            }
                            if (value.contains(s + "=") || !value.startsWith(urlContext) || (parameter = renderContext.getRequest().getParameter(s)) == null) continue;
                            newValue.append(separateChar).append(s).append("=").append(parameter);
                            separateChar = "&";
                        }
                        return newValue.toString();
                    }
                    return value;
                }
            });
        }
        return previousOut;
    }

    public void setTraverser(HtmlTagAttributeTraverser traverser) {
        this.traverser = traverser;
    }
}

