/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.exceptions.JahiaServiceUnavailableException;
import org.jahia.services.render.RenderContext;
import org.jahia.tools.jvm.ThreadMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ModuleGeneratorQueue
implements InitializingBean {
    public static final String HAS_PROCESSING_SEMAPHORE_PARAM = "moduleGeneratorQueue.hasProcessingSemaphore";
    private Map<String, String> notCacheableModule = new ConcurrentHashMap<String, String>(2503);
    private Map<String, CountDownLatch> generatingModules;
    private int maxModulesToGenerateInParallel = 50;
    private long moduleGenerationWaitTime = 5000L;
    private volatile Semaphore availableProcessings = null;
    private long minimumIntervalAfterLastAutoThreadDump = 60000L;
    private boolean threadDumpToSystemOut = true;
    private boolean threadDumpToFile = true;
    private static long lastThreadDumpTime = 0L;
    private Byte[] threadDumpCheckLock = new Byte[0];
    private static ThreadLocal<Set<CountDownLatch>> processingLatches = new ThreadLocal();
    private static ThreadLocal<String> generatingKeySemaphore = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(ModuleGeneratorQueue.class);

    public Map<String, String> getNotCacheableModule() {
        return this.notCacheableModule;
    }

    public Map<String, CountDownLatch> getGeneratingModules() {
        return this.generatingModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Semaphore getAvailableProcessings() {
        Semaphore result = this.availableProcessings;
        if (result == null) {
            ModuleGeneratorQueue moduleGeneratorQueue = this;
            synchronized (moduleGeneratorQueue) {
                result = this.availableProcessings;
                if (result == null) {
                    this.availableProcessings = result = new Semaphore(this.maxModulesToGenerateInParallel, true);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch avoidParallelProcessingOfSameModule(String key, HttpServletRequest request) throws Exception {
        CountDownLatch latch;
        boolean mustWait = true;
        if (this.generatingModules.get(key) == null) {
            this.getFragmentsGenerationPermit(key, request);
        }
        Map<String, CountDownLatch> map = this.generatingModules;
        synchronized (map) {
            latch = this.generatingModules.get(key);
            if (latch == null) {
                latch = new CountDownLatch(1);
                this.generatingModules.put(key, latch);
                mustWait = false;
            }
        }
        if (mustWait) {
            this.releaseFragmentsGenerationPermit(request);
            try {
                if (!latch.await(this.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                    this.manageThreadDump();
                    StringBuilder errorMsgBuilder = new StringBuilder(512);
                    errorMsgBuilder.append("Module generation takes too long due to module not generated fast enough (>").append(this.moduleGenerationWaitTime).append(" ms)- ").append(key).append(" - ").append(request.getRequestURI());
                    throw new JahiaServiceUnavailableException(errorMsgBuilder.toString());
                }
                latch = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new JahiaRuntimeException(e);
            }
        }
        return latch;
    }

    protected void getFragmentsGenerationPermit(String resourceIdentifier, HttpServletRequest request) {
        if (!Boolean.TRUE.equals(request.getAttribute(HAS_PROCESSING_SEMAPHORE_PARAM))) {
            try {
                if (!this.getAvailableProcessings().tryAcquire(this.getModuleGenerationWaitTime(), TimeUnit.MILLISECONDS)) {
                    this.manageThreadDump();
                    StringBuilder errorMsgBuilder = new StringBuilder(512).append("Module generation takes too long due to maximum parallel processing reached (").append(this.maxModulesToGenerateInParallel).append(") - ").append(resourceIdentifier).append(" - ").append(request.getRequestURI());
                    throw new JahiaServiceUnavailableException(errorMsgBuilder.toString());
                }
                request.setAttribute(HAS_PROCESSING_SEMAPHORE_PARAM, (Object)Boolean.TRUE);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new JahiaRuntimeException(ie);
            }
        }
    }

    protected void releaseFragmentsGenerationPermit(HttpServletRequest request) {
        if (Boolean.TRUE.equals(request.getAttribute(HAS_PROCESSING_SEMAPHORE_PARAM))) {
            this.getAvailableProcessings().release();
            request.removeAttribute(HAS_PROCESSING_SEMAPHORE_PARAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void manageThreadDump() {
        boolean createDump = false;
        if (this.minimumIntervalAfterLastAutoThreadDump > -1L && (this.threadDumpToSystemOut || this.threadDumpToFile)) {
            long now = System.currentTimeMillis();
            Byte[] byteArray = this.threadDumpCheckLock;
            // MONITORENTER : this.threadDumpCheckLock
            if (now > lastThreadDumpTime + this.minimumIntervalAfterLastAutoThreadDump) {
                createDump = true;
                lastThreadDumpTime = now;
            }
            // MONITOREXIT : byteArray
        }
        if (!createDump) return;
        ThreadMonitor tm = ThreadMonitor.getInstance();
        tm.dumpThreadInfo(this.threadDumpToSystemOut, this.threadDumpToFile);
    }

    protected boolean getLatch(RenderContext renderContext, String finalKey) throws Exception {
        CountDownLatch latch = this.avoidParallelProcessingOfSameModule(finalKey, renderContext.getRequest());
        if (latch == null) {
            return true;
        }
        Set<CountDownLatch> latches = processingLatches.get();
        if (latches == null) {
            latches = new HashSet<CountDownLatch>();
            processingLatches.set(latches);
        }
        latches.add(latch);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLatch(String finalKey) {
        Set<CountDownLatch> latches = processingLatches.get();
        CountDownLatch latch = this.generatingModules.get(finalKey);
        if (latches != null && latches.contains(latch)) {
            latch.countDown();
            Map<String, CountDownLatch> map = this.generatingModules;
            synchronized (map) {
                latches.remove(this.generatingModules.remove(finalKey));
            }
        }
    }

    public int getMaxModulesToGenerateInParallel() {
        return this.maxModulesToGenerateInParallel;
    }

    public long getModuleGenerationWaitTime() {
        return this.moduleGenerationWaitTime;
    }

    public void afterPropertiesSet() throws Exception {
        this.generatingModules = new HashMap<String, CountDownLatch>(this.maxModulesToGenerateInParallel);
    }

    public void setMaxModulesToGenerateInParallel(int maxModulesToGenerateInParallel) {
        this.maxModulesToGenerateInParallel = maxModulesToGenerateInParallel;
        this.availableProcessings = null;
    }

    public void setModuleGenerationWaitTime(long moduleGenerationWaitTime) {
        this.moduleGenerationWaitTime = moduleGenerationWaitTime;
    }

    public void setMinimumIntervalAfterLastAutoThreadDump(long minimumIntervalAfterLastAutoThreadDump) {
        this.minimumIntervalAfterLastAutoThreadDump = minimumIntervalAfterLastAutoThreadDump;
    }

    public long getMinimumIntervalAfterLastAutoThreadDump() {
        return this.minimumIntervalAfterLastAutoThreadDump;
    }

    public boolean isThreadDumpToSystemOut() {
        return this.threadDumpToSystemOut;
    }

    public void setThreadDumpToSystemOut(boolean threadDumpToSystemOut) {
        this.threadDumpToSystemOut = threadDumpToSystemOut;
    }

    public boolean isThreadDumpToFile() {
        return this.threadDumpToFile;
    }

    public void setThreadDumpToFile(boolean threadDumpToFile) {
        this.threadDumpToFile = threadDumpToFile;
    }
}

