/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.portlet;

import javax.portlet.PortletException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.applications.pluto.JahiaPortletUtil;
import org.jahia.services.applications.pluto.JahiaUserRequestWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlutoProcessActionFilter
extends AbstractFilter {
    private static final Logger logger = LoggerFactory.getLogger(PlutoProcessActionFilter.class);
    private boolean renderOnAction;

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (this.renderOnAction) {
            return StringUtils.defaultString((String)this.performAction(previousOut, renderContext, resource, chain), (String)previousOut);
        }
        return previousOut;
    }

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        return !this.renderOnAction ? this.performAction(null, renderContext, resource, chain) : null;
    }

    private String performAction(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        block19: {
            try {
                JahiaUserRequestWrapper request = new JahiaUserRequestWrapper(renderContext.getUser(), renderContext.getRequest(), renderContext.getMainResource().getWorkspace());
                HttpServletResponse response = renderContext.getResponse();
                ServletContext servletContext = JahiaContextLoaderListener.getServletContext();
                PortletContainer container = (PortletContainer)servletContext.getAttribute("portletContainer");
                PortalRequestContext portalRequestContext = new PortalRequestContext(servletContext, (HttpServletRequest)request, response);
                PortalURL portalURL = portalRequestContext.getRequestedPortalURL();
                String actionWindowId = portalURL.getActionWindow();
                String resourceWindowId = portalURL.getResourceWindow();
                PortletWindowConfig actionWindowConfig = null;
                PortletWindowConfig resourceWindowConfig = null;
                if (resourceWindowId != null) {
                    resourceWindowConfig = PortletWindowConfig.fromId((String)resourceWindowId);
                } else if (actionWindowId != null) {
                    actionWindowConfig = PortletWindowConfig.fromId((String)actionWindowId);
                }
                if (actionWindowConfig != null) {
                    EntryPointInstance entryPointInstance;
                    PortletWindowImpl portletWindow = new PortletWindowImpl(container, actionWindowConfig, portalURL);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing action request for window: " + portletWindow.getId().getStringId());
                    }
                    if ((entryPointInstance = ServicesRegistry.getInstance().getApplicationsManagerService().getEntryPointInstance(actionWindowConfig.getMetaInfo(), renderContext.getMainResource().getWorkspace())) != null) {
                        request.setEntryPointInstance(entryPointInstance);
                    } else {
                        logger.warn("Couldn't find related entryPointInstance, roles might not work properly !");
                    }
                    JahiaPortletUtil.copyJahiaAttributes(entryPointInstance, renderContext.getRequest(), (PortletWindow)portletWindow, (HttpServletRequest)request, true, renderContext.getMainResource().getWorkspace());
                    try {
                        container.doAction((PortletWindow)portletWindow, (HttpServletRequest)request, renderContext.getResponse());
                        renderContext.setPortletActionRequest(!this.renderOnAction);
                        JahiaPortletUtil.copySharedMapFromPortletToJahia(renderContext.getRequest().getSession(), (HttpServletRequest)request, (PortletWindow)portletWindow);
                    }
                    catch (PortletContainerException ex) {
                        throw new ServletException((Throwable)ex);
                    }
                    catch (PortletException ex) {
                        throw new ServletException((Throwable)ex);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Action request processed, send a redirect.");
                    }
                    return "";
                }
                if (resourceWindowConfig == null) break block19;
                PortletWindowImpl portletWindow = new PortletWindowImpl(container, resourceWindowConfig, portalURL);
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing resource Serving request for window: " + portletWindow.getId().getStringId());
                }
                try {
                    container.doServeResource((PortletWindow)portletWindow, (HttpServletRequest)request, response);
                    renderContext.setPortletActionRequest(!this.renderOnAction);
                }
                catch (PortletContainerException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new ServletException((Throwable)ex);
                }
                catch (PortletException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new ServletException((Throwable)ex);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Resource serving request processed.");
                }
                return "";
            }
            catch (Exception t) {
                logger.error("Error while processing action", (Throwable)t);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(renderContext.getRequest().getRequestURI() + " is a renderURL");
        }
        return null;
    }

    public void setRenderOnAction(boolean renderOnAction) {
        this.renderOnAction = renderOnAction;
    }
}

