/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jahia.services.render.scripting.bundle.BundleScriptEngine;
import org.jahia.services.render.scripting.bundle.BundleScriptingContext;
import org.jahia.services.render.scripting.bundle.Configurable;
import org.osgi.framework.Bundle;

class BundleScriptEngineFactory
implements Configurable,
ScriptEngineFactory {
    private final ScriptEngineFactory factory;
    private final BundleScriptingContext context;
    private final String wrappedFactoryClassName;
    private final boolean isConfigurable;

    BundleScriptEngineFactory(ScriptEngineFactory factory, BundleScriptingContext context) {
        this.factory = factory;
        this.isConfigurable = factory instanceof Configurable;
        this.wrappedFactoryClassName = factory.getClass().getCanonicalName();
        this.context = context;
    }

    @Override
    public String getEngineName() {
        return this.factory.getEngineName();
    }

    @Override
    public String getEngineVersion() {
        return this.factory.getEngineVersion();
    }

    @Override
    public List<String> getExtensions() {
        return this.factory.getExtensions();
    }

    @Override
    public String getLanguageName() {
        return this.factory.getLanguageName();
    }

    @Override
    public String getLanguageVersion() {
        return this.factory.getLanguageVersion();
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return this.factory.getMethodCallSyntax(obj, m, args);
    }

    @Override
    public List<String> getMimeTypes() {
        return this.factory.getMimeTypes();
    }

    @Override
    public List<String> getNames() {
        return this.factory.getNames();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return this.factory.getOutputStatement(toDisplay);
    }

    @Override
    public Object getParameter(String key) {
        return this.factory.getParameter(key);
    }

    @Override
    public String getProgram(String ... statements) {
        return this.factory.getProgram(statements);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        ScriptEngine engine;
        ClassLoader contextClassLoader = this.context.getClassLoader();
        if (contextClassLoader != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            engine = new BundleScriptEngine(this.factory.getScriptEngine(), this);
            Thread.currentThread().setContextClassLoader(old);
        } else {
            engine = this.factory.getScriptEngine();
        }
        return engine;
    }

    public String toString() {
        return "BundleScriptEngineFactory wrapping " + this.wrappedFactoryClassName;
    }

    BundleScriptingContext getContext() {
        return this.context;
    }

    String getWrappedFactoryClassName() {
        return this.wrappedFactoryClassName;
    }

    private Configurable getWrappedAsConfigurable() {
        return (Configurable)((Object)this.factory);
    }

    @Override
    public void configurePreRegistration(Bundle bundle) {
        if (this.isConfigurable) {
            this.getWrappedAsConfigurable().configurePreRegistration(bundle);
        }
    }

    @Override
    public void destroy(Bundle bundle) {
        if (this.isConfigurable) {
            this.getWrappedAsConfigurable().destroy(bundle);
        }
    }

    @Override
    public void configurePreScriptEngineCreation() {
        if (this.isConfigurable) {
            this.getWrappedAsConfigurable().configurePreScriptEngineCreation();
        }
    }
}

