/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.scripting.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.script.ScriptEngineFactory;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.ExtensionObserverRegistry;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.channels.Channel;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.BundleView;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.render.scripting.ScriptFactory;
import org.jahia.services.render.scripting.ScriptResolver;
import org.jahia.services.render.scripting.bundle.BundleJSR223ScriptFactory;
import org.jahia.services.render.scripting.bundle.BundleScriptEngineFactory;
import org.jahia.services.render.scripting.bundle.BundleScriptEngineManager;
import org.jahia.services.render.scripting.bundle.BundleScriptingContext;
import org.jahia.services.render.scripting.bundle.ScriptBundleObserver;
import org.jahia.services.render.scripting.bundle.ScriptBundleURLScanner;
import org.jahia.services.render.scripting.bundle.ViewResourceInfo;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.utils.ScriptEngineUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class BundleScriptResolver
implements ScriptResolver,
ApplicationListener<ApplicationEvent> {
    private static final int PRIORITY_STAGGER_FACTOR = 100;
    private static final String EXTENSION_PATTERN_PREFIX = "*.";
    private static Logger logger = LoggerFactory.getLogger(BundleScriptResolver.class);
    private static Map<String, SortedSet<View>> viewSetCache = new ConcurrentHashMap<String, SortedSet<View>>(512);
    private Map<String, SortedMap<String, ViewResourceInfo>> availableScripts = new HashMap<String, SortedMap<String, ViewResourceInfo>>(64);
    private LinkedHashMap<String, ScriptFactory> scriptFactoryMap;
    private Set<String> preRegisteredExtensions;
    private HashMap<String, Integer> extensionPriorities;
    private JahiaTemplateManagerService templateManagerService;
    private final Comparator<ViewResourceInfo> scriptExtensionComparator = new Comparator<ViewResourceInfo>(){

        @Override
        public int compare(ViewResourceInfo o1, ViewResourceInfo o2) {
            if (Objects.equals(o1, o2)) {
                return 1;
            }
            Integer o1Priority = (Integer)BundleScriptResolver.this.extensionPriorities.get(o1.extension);
            Integer o2Priority = (Integer)BundleScriptResolver.this.extensionPriorities.get(o2.extension);
            if (o1Priority == null) {
                throw new IllegalArgumentException("Unknown extension " + o1.extension);
            }
            if (o2Priority == null) {
                throw new IllegalArgumentException("Unknown extension " + o2.extension);
            }
            int i = o1Priority - o2Priority;
            return i != 0 ? i : 1;
        }
    };
    private BundleJSR223ScriptFactory bundleScriptFactory;
    private ExtensionObserverRegistry observerRegistry;
    private final ScriptBundleObserver scriptBundleObserver = new ScriptBundleObserver(this);
    private Set<String> ignoredBundlePrefixes = new HashSet<String>(7);

    public void setIgnoredBundlePrefixes(Set<String> ignoredBundlePrefixes) {
        this.ignoredBundlePrefixes = ignoredBundlePrefixes;
    }

    public void setExtensionObserverRegistry(ExtensionObserverRegistry extensionObserverRegistry) {
        this.observerRegistry = extensionObserverRegistry;
    }

    public ExtensionObserverRegistry getObserverRegistry() {
        return this.observerRegistry;
    }

    public void registerObservers() {
        for (String scriptExtension : this.scriptFactoryMap.keySet()) {
            this.registerObserver(scriptExtension);
        }
    }

    private void registerObserver(String extension) {
        this.observerRegistry.put(new ScriptBundleURLScanner("/", extension, true), this.scriptBundleObserver);
    }

    private void removeObserver(String extension) {
        this.observerRegistry.remove(new ScriptBundleURLScanner("/", extension, true));
    }

    public ScriptBundleObserver getBundleObserver() {
        return this.scriptBundleObserver;
    }

    public static BundleScriptResolver getInstance() {
        return Holder.INSTANCE;
    }

    public void setScriptFactoryMap(Map<String, ScriptFactory> scriptFactoryMap) {
        if (!(scriptFactoryMap instanceof LinkedHashMap)) {
            throw new IllegalArgumentException("Error instantiating BundleScriptResolver: Spring is supposed to create a SortedMap when using a <map> property but didn't. Was: " + scriptFactoryMap.getClass().getName());
        }
        this.scriptFactoryMap = (LinkedHashMap)scriptFactoryMap;
        this.preRegisteredExtensions = new HashSet<String>(scriptFactoryMap.size());
        this.preRegisteredExtensions.addAll(scriptFactoryMap.keySet());
        this.extensionPriorities = new HashMap(scriptFactoryMap.size());
        int i = 0;
        for (String extension : scriptFactoryMap.keySet()) {
            this.extensionPriorities.put(extension, 100 * i);
            ++i;
        }
    }

    public void register(ScriptEngineFactory scriptEngineFactory, Bundle bundle) {
        BundleScriptingContext context;
        List<String> extensions = scriptEngineFactory.getExtensions();
        if (extensions.isEmpty()) {
            return;
        }
        if (scriptEngineFactory instanceof BundleScriptEngineFactory) {
            BundleScriptEngineFactory engineFactory = (BundleScriptEngineFactory)scriptEngineFactory;
            context = engineFactory.getContext();
        } else {
            context = null;
        }
        for (String extension : extensions) {
            ScriptFactory scriptFactory = this.scriptFactoryMap.get(extension);
            if (scriptFactory != null) {
                ScriptEngineFactory scriptEngineFactory2 = BundleScriptEngineManager.getInstance().getFactoryForExtension(extension);
                throw new IllegalArgumentException("Extension " + extension + " is already associated with ScriptEngineFactory " + scriptEngineFactory2);
            }
            this.scriptFactoryMap.put(extension, this.bundleScriptFactory);
            int n = this.getPriority(extension, context);
            this.extensionPriorities.put(extension, n);
            logger.info("ScriptEngineFactory {} registered extension {} with priority {}", new Object[]{scriptEngineFactory, extension, n});
            this.addBundleScripts(bundle, extension);
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext != null) {
                for (Bundle otherBundle : bundleContext.getBundles()) {
                    if (otherBundle.getState() != 32) continue;
                    this.addBundleScripts(otherBundle, extension);
                }
            }
            this.registerObserver(extension);
        }
        if (context != null && context.specifiesExtensionPriorities()) {
            Map<String, Integer> specifiedPriorities = context.getExtensionPriorities();
            TreeMap<Integer, String> orderedPriorities = new TreeMap<Integer, String>();
            for (Map.Entry entry : this.extensionPriorities.entrySet()) {
                String extension = (String)entry.getKey();
                Integer priority = (Integer)entry.getValue();
                Integer newPriority = specifiedPriorities.get(extension);
                if (newPriority != null) {
                    this.extensionPriorities.put(extension, newPriority);
                    priority = newPriority;
                }
                orderedPriorities.put(priority, extension);
            }
            Set<String> specifiedExtensions = specifiedPriorities.keySet();
            specifiedExtensions.removeAll(this.extensionPriorities.keySet());
            if (!specifiedExtensions.isEmpty()) {
                logger.warn("Module {} specified priorities for unknown extensions {}", (Object)bundle.getSymbolicName(), specifiedExtensions);
            }
            logger.info("Extension priorities got re-ordered by module {} to {}", (Object)bundle.getSymbolicName(), orderedPriorities);
        }
    }

    private int getPriority(String extension, BundleScriptingContext context) {
        int defaultPriority = this.extensionPriorities.size() * 100;
        if (context == null) {
            return defaultPriority;
        }
        return context.getPriority(extension, defaultPriority);
    }

    public void remove(ScriptEngineFactory factory, Bundle bundle) {
        List<String> extensions = factory.getExtensions();
        for (String extension : extensions) {
            this.availableScripts.remove(bundle.getSymbolicName());
            for (Bundle otherBundle : bundle.getBundleContext().getBundles()) {
                if (otherBundle.getState() != 32) continue;
                this.removeBundleScripts(otherBundle, extension);
            }
            this.scriptFactoryMap.remove(extension);
            this.extensionPriorities.remove(extension);
            this.removeObserver(extension);
        }
    }

    static boolean shouldBeScannedForViews(Bundle bundle, String viewExtension) {
        if (BundleScriptResolver.isIgnoredBundle(bundle)) {
            return false;
        }
        if (BundleScriptResolver.isPreRegisteredExtension(viewExtension)) {
            return true;
        }
        ScriptEngineFactory scriptFactory = BundleScriptEngineManager.getInstance().getFactoryForExtension(viewExtension);
        if (scriptFactory == null) {
            return false;
        }
        Dictionary headers = bundle.getHeaders();
        return ScriptEngineUtils.canFactoryProcessViews(scriptFactory, headers);
    }

    private static boolean isIgnoredBundle(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        for (String ignoredBundlePrefix : BundleScriptResolver.getInstance().ignoredBundlePrefixes) {
            if (!symbolicName.startsWith(ignoredBundlePrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPreRegisteredExtension(String viewExtension) {
        return BundleScriptResolver.getInstance().preRegisteredExtensions.contains(viewExtension);
    }

    private void addBundleScripts(Bundle bundle, String extension) {
        String extensionPattern;
        Enumeration entries;
        if (BundleScriptResolver.shouldBeScannedForViews(bundle, extension) && (entries = bundle.findEntries("/", extensionPattern = BundleScriptResolver.getExtensionPattern(extension), true)) != null) {
            LinkedList<URL> scripts = new LinkedList<URL>();
            while (entries.hasMoreElements()) {
                scripts.add((URL)entries.nextElement());
            }
            this.addBundleScripts(bundle, scripts);
        }
    }

    static String getExtensionPattern(String extension) {
        return EXTENSION_PATTERN_PREFIX + extension;
    }

    private void removeBundleScripts(Bundle bundle, String extension) {
        String extensionPattern;
        Enumeration entries;
        if (BundleScriptResolver.shouldBeScannedForViews(bundle, extension) && (entries = bundle.findEntries("/", extensionPattern = BundleScriptResolver.getExtensionPattern(extension), true)) != null) {
            LinkedList<URL> scripts = new LinkedList<URL>();
            while (entries.hasMoreElements()) {
                scripts.add((URL)entries.nextElement());
            }
            this.removeBundleScripts(bundle, scripts);
        }
    }

    public void addBundleScripts(Bundle bundle, List<URL> scripts) {
        if (!scripts.isEmpty()) {
            for (URL script : scripts) {
                this.addBundleScript(bundle, script.getPath());
            }
            logger.info("Bundle {} registered {} views", (Object)bundle, logger.isDebugEnabled() ? scripts : Integer.valueOf(scripts.size()));
        }
    }

    public void addBundleScript(Bundle bundle, String path) {
        if (path.split("/").length != 4) {
            return;
        }
        ViewResourceInfo scriptResource = new ViewResourceInfo(path);
        String symbolicName = bundle.getSymbolicName();
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(symbolicName);
        if (existingBundleScripts == null) {
            existingBundleScripts = new TreeMap<String, ViewResourceInfo>();
            this.availableScripts.put(symbolicName, existingBundleScripts);
            existingBundleScripts.put(scriptResource.path, scriptResource);
        } else if (!existingBundleScripts.containsKey(scriptResource.path)) {
            existingBundleScripts.put(scriptResource.path, scriptResource);
        } else {
            scriptResource = (ViewResourceInfo)existingBundleScripts.get(scriptResource.path);
        }
        String properties = StringUtils.substringBeforeLast((String)path, (String)".") + ".properties";
        URL propertiesResource = bundle.getResource(properties);
        if (propertiesResource != null) {
            Properties p = new Properties();
            try (InputStream inStream = propertiesResource.openStream();){
                p.load(inStream);
            }
            catch (IOException e) {
                logger.error("Cannot read properties", (Throwable)e);
            }
            scriptResource.setProperties(p);
        } else {
            scriptResource.setProperties(new Properties());
        }
        BundleScriptResolver.clearCaches();
    }

    public void removeBundleScripts(Bundle bundle, List<URL> scripts) {
        String bundleName = bundle.getSymbolicName();
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(bundleName);
        if (existingBundleScripts == null) {
            return;
        }
        if (!scripts.isEmpty()) {
            boolean didRemove = false;
            for (URL script : scripts) {
                didRemove = existingBundleScripts.remove(script.getPath()) != null;
            }
            if (didRemove) {
                if (existingBundleScripts.isEmpty()) {
                    this.availableScripts.remove(bundleName);
                }
                logger.info("Bundle {} unregistered {} views", (Object)bundle, scripts);
                BundleScriptResolver.clearCaches();
            }
        }
    }

    public void removeBundleScript(Bundle bundle, String path) {
        SortedMap<String, ViewResourceInfo> existingBundleScripts = this.availableScripts.get(bundle.getSymbolicName());
        if (existingBundleScripts == null) {
            return;
        }
        existingBundleScripts.remove(path);
        BundleScriptResolver.clearCaches();
    }

    @Override
    public Script resolveScript(Resource resource, RenderContext renderContext) throws TemplateNotFoundException {
        try {
            View resolvedView = this.resolveView(resource, renderContext);
            if (resolvedView == null) {
                throw new TemplateNotFoundException("Unable to find the view for resource " + resource);
            }
            if (this.scriptFactoryMap.containsKey(resolvedView.getFileExtension())) {
                return this.scriptFactoryMap.get(resolvedView.getFileExtension()).createScript(resolvedView);
            }
            throw new TemplateNotFoundException("Unable to script factory map extension handler for the resolved view " + resolvedView.getInfo());
        }
        catch (RepositoryException e) {
            throw new TemplateNotFoundException(e);
        }
    }

    private View resolveView(Resource resource, RenderContext renderContext) throws RepositoryException {
        ExtendedNodeType nt = resource.getNode().getPrimaryNodeType();
        List<ExtendedNodeType> nodeTypeList = this.getNodeTypeList(nt);
        for (ExtendedNodeType type : resource.getNode().getMixinNodeTypes()) {
            nodeTypeList.addAll(0, type.getSupertypeSet());
            nodeTypeList.add(0, type);
        }
        if (resource.getResourceNodeType() != null) {
            nodeTypeList.addAll(0, this.getNodeTypeList(resource.getResourceNodeType()));
        }
        return this.resolveView(resource, nodeTypeList, renderContext);
    }

    private View resolveView(Resource resource, List<ExtendedNodeType> nodeTypeList, RenderContext renderContext) {
        SortedSet<View> s;
        View selected;
        String template = resource.getResolvedTemplate();
        JCRSiteNode site = renderContext.getSite();
        List<String> templateTypeMappings = null;
        Channel channel = renderContext.getChannel();
        if (channel != null && !channel.getFallBack().equals("root")) {
            templateTypeMappings = new LinkedList<String>();
            while (!channel.getFallBack().equals("root")) {
                if (channel.getCapability("template-type-mapping") != null) {
                    templateTypeMappings.add(resource.getTemplateType() + "-" + channel.getCapability("template-type-mapping"));
                }
                channel = ChannelService.getInstance().getChannel(channel.getFallBack());
            }
            templateTypeMappings.add(resource.getTemplateType());
        }
        if ((selected = this.getView(template, s = this.getViewsSet(nodeTypeList, site, templateTypeMappings != null ? templateTypeMappings : Collections.singletonList(resource.getTemplateType())))) == null && !"default".equals(template)) {
            selected = this.getView("default", s);
        }
        return selected;
    }

    private View getView(String template, Set<View> s) {
        for (View view : s) {
            if (!view.getKey().equals(template)) continue;
            return view;
        }
        return null;
    }

    @Override
    public boolean hasView(ExtendedNodeType nt, String key, JCRSiteNode site, String templateType) {
        for (View view : this.getViewsSet(nt, site, templateType)) {
            if (!view.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<View> getViewsSet(ExtendedNodeType nt, JCRSiteNode site, String templateType) {
        try {
            return this.getViewsSet(this.getNodeTypeList(nt), site, Collections.singletonList(templateType));
        }
        catch (NoSuchNodeTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private List<ExtendedNodeType> getNodeTypeList(ExtendedNodeType nt) throws NoSuchNodeTypeException {
        LinkedList<ExtendedNodeType> nodeTypeList = new LinkedList<ExtendedNodeType>();
        nodeTypeList.add(nt);
        nodeTypeList.addAll(nt.getSupertypeSet());
        ExtendedNodeType base = NodeTypeRegistry.getInstance().getNodeType("nt:base");
        if (nodeTypeList.remove(base)) {
            nodeTypeList.add(base);
        }
        return nodeTypeList;
    }

    private SortedSet<View> getViewsSet(List<ExtendedNodeType> nodeTypeList, JCRSiteNode site, List<String> templateTypes) {
        StringBuilder cacheKey = new StringBuilder();
        for (ExtendedNodeType extendedNodeType : nodeTypeList) {
            cacheKey.append(extendedNodeType.getName()).append("_");
        }
        cacheKey.append("_").append(site != null ? site.getPath() : "").append("__");
        for (String string : templateTypes) {
            cacheKey.append(string).append("_");
        }
        String s = cacheKey.toString();
        if (viewSetCache.containsKey(s)) {
            return viewSetCache.get(s);
        }
        HashMap<String, View> hashMap = new HashMap<String, View>();
        Set<String> installedModules = this.getInstalledModules(site);
        for (ExtendedNodeType type : nodeTypeList) {
            JahiaTemplatesPackage defaultModule;
            boolean defaultModuleProcessed = false;
            Set<JahiaTemplatesPackage> packages = this.templateManagerService.getModulesWithViewsForComponent(JCRContentUtils.replaceColon(type.getName()));
            for (JahiaTemplatesPackage aPackage : packages) {
                String packageName = aPackage.getId();
                if (installedModules != null && !installedModules.contains(packageName)) continue;
                if (aPackage.isDefault()) {
                    defaultModuleProcessed = true;
                }
                for (String templateType : templateTypes) {
                    this.getViewsSet(type, hashMap, templateType, aPackage);
                }
            }
            if (type.getTemplatePackage() != null && installedModules != null && !installedModules.contains(type.getSystemId())) {
                for (String templateType : templateTypes) {
                    this.getViewsSet(type, hashMap, templateType, type.getTemplatePackage());
                }
            }
            if (defaultModuleProcessed || (defaultModule = this.templateManagerService.getTemplatePackageById("default")) == null) continue;
            for (String templateType : templateTypes) {
                this.getViewsSet(type, hashMap, templateType, defaultModule);
            }
        }
        TreeSet<View> t = new TreeSet<View>(hashMap.values());
        viewSetCache.put(s, t);
        return t;
    }

    private Set<String> getInstalledModules(JCRSiteNode site) {
        if (site == null) {
            return null;
        }
        Set<String> installedModules = null;
        String sitePath = site.getPath();
        if (sitePath.startsWith("/sites/")) {
            installedModules = site.getInstalledModulesWithAllDependencies();
        } else if (sitePath.startsWith("/modules/")) {
            JahiaTemplatesPackage aPackage = this.templateManagerService.getTemplatePackageById(site.getName());
            if (aPackage != null) {
                installedModules = new LinkedHashSet<String>();
                installedModules.add(aPackage.getId());
                for (JahiaTemplatesPackage depend : aPackage.getDependencies()) {
                    if (installedModules.contains(depend.getId())) continue;
                    installedModules.add(depend.getId());
                }
            }
            if (installedModules != null) {
                installedModules.add("templates-system");
                for (JahiaTemplatesPackage depend : this.templateManagerService.getTemplatePackageById("templates-system").getDependencies()) {
                    if (installedModules.contains(depend.getId())) continue;
                    installedModules.add(depend.getId());
                }
            }
        }
        return installedModules;
    }

    private void getViewsSet(ExtendedNodeType nt, Map<String, View> views, String templateType, JahiaTemplatesPackage tplPackage) {
        StringBuilder pathBuilder = new StringBuilder(64);
        pathBuilder.append("/").append(JCRContentUtils.replaceColon(nt.getAlias())).append("/").append(templateType).append("/");
        pathBuilder.append(nt.getName().contains(":") ? StringUtils.substringAfter((String)nt.getName(), (String)":") : nt.getName()).append(".");
        Set<ViewResourceInfo> sortedScripts = this.findBundleScripts(tplPackage.getId(), pathBuilder.toString());
        Properties defaultProperties = null;
        if (!sortedScripts.isEmpty()) {
            defaultProperties = new Properties();
            JahiaTemplatesPackage aPackage = nt.getTemplatePackage();
            if (aPackage == null) {
                aPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("default");
            }
            if (!aPackage.getId().equals(tplPackage.getId())) {
                Set<ViewResourceInfo> defaultScripts = this.findBundleScripts(aPackage.getId(), pathBuilder.toString());
                Iterator iterator = defaultScripts.iterator();
                while (iterator.hasNext()) {
                    ViewResourceInfo defaultScript = (ViewResourceInfo)iterator.next();
                    if (!defaultScript.viewKey.equals("default")) continue;
                    defaultProperties.putAll((Map<?, ?>)defaultScript.getProperties());
                    break;
                }
            }
            for (ViewResourceInfo defaultScript : sortedScripts) {
                if (!defaultScript.viewKey.equals("default")) continue;
                defaultProperties.putAll((Map<?, ?>)defaultScript.getProperties());
                break;
            }
        }
        for (ViewResourceInfo res : sortedScripts) {
            if (views.containsKey(res.viewKey)) continue;
            if (!this.scriptFactoryMap.containsKey(res.extension)) {
                logger.error("Script extension {} can not be handled by this system.", (Object)res.extension);
                break;
            }
            BundleView view = new BundleView(res.path, res.viewKey, tplPackage, res.filename);
            view.setProperties(res.getProperties());
            view.setDefaultProperties(defaultProperties);
            views.put(res.viewKey, view);
            this.scriptFactoryMap.get(res.extension).initView(view);
        }
    }

    private Set<ViewResourceInfo> findBundleScripts(String module, String pathPrefix) {
        SortedMap<String, ViewResourceInfo> allBundleScripts = this.availableScripts.get(module);
        if (allBundleScripts == null || allBundleScripts.isEmpty()) {
            return Collections.emptySet();
        }
        SortedMap<String, ViewResourceInfo> viewInfosWithPathGTEThanPrefix = allBundleScripts.tailMap(pathPrefix);
        if (viewInfosWithPathGTEThanPrefix.isEmpty()) {
            return Collections.emptySet();
        }
        if (!viewInfosWithPathGTEThanPrefix.firstKey().startsWith(pathPrefix)) {
            return Collections.emptySet();
        }
        TreeSet<ViewResourceInfo> sortedScripts = new TreeSet<ViewResourceInfo>(this.scriptExtensionComparator);
        for (Map.Entry<String, ViewResourceInfo> entry : viewInfosWithPathGTEThanPrefix.entrySet()) {
            if (entry.getKey().startsWith(pathPrefix)) {
                sortedScripts.add(entry.getValue());
                continue;
            }
            return sortedScripts;
        }
        return sortedScripts;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof JahiaTemplateManagerService.TemplatePackageRedeployedEvent || event instanceof JahiaTemplateManagerService.ModuleDeployedOnSiteEvent || event instanceof JahiaTemplateManagerService.ModuleDependenciesEvent) {
            BundleScriptResolver.clearCaches();
        }
    }

    public static void clearCaches() {
        viewSetCache.clear();
    }

    public void setBundleScriptFactory(BundleJSR223ScriptFactory bundleScriptFactory) {
        this.bundleScriptFactory = bundleScriptFactory;
    }

    private static class Holder {
        static final BundleScriptResolver INSTANCE = new BundleScriptResolver();

        private Holder() {
        }
    }
}

